<?php

namespace Carreiro\Http\Controllers;

use Carreiro\Delegacion;
use Carreiro\Direccion;
use Carreiro\Estado;
use Illuminate\Http\Request;

class DireccionController extends Controller
{
    public function estado($estado)
    {
        $id_estado = Estado::where('nombre', $estado)->value('id');
        $direcciones = Delegacion::where('estado_id', $id_estado)->pluck('nombre');
        return $direcciones;
    }

    public function delegacion($estado, $delegacion)
    {
        $id_estado = Estado::where('nombre', $estado)->value('id');
        if ($delegacion == 'N-D') {
            $delegacion = 'N/D';
        }
        $id_delegacion = Delegacion::where('nombre', $delegacion)->value('id');
        $direcciones = Direccion::where([
            ['estado_id', $id_estado],
            ['delegacion_id', $id_delegacion]
        ])->get();
        return $direcciones;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \Carreiro\Direccion  $direccion
     * @return \Illuminate\Http\Response
     */
    public function show(Direccion $direccion)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \Carreiro\Direccion  $direccion
     * @return \Illuminate\Http\Response
     */
    public function edit(Direccion $direccion)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Carreiro\Direccion  $direccion
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Direccion $direccion)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \Carreiro\Direccion  $direccion
     * @return \Illuminate\Http\Response
     */
    public function destroy(Direccion $direccion)
    {
        //
    }
}
