@extends('layout')

@section('css')
	<link rel="stylesheet" href="{{ asset('css/acordeon.css?v=13') }}">
	<link rel="stylesheet" href="{{ asset('css/unleash.3.css') }}">
@endsection

@section('contenido')
	@if ($agent->isMobile())
		
		<section class="ajuste_menu" id="acordeon_mobil">
			<div class="container">
				<div class="row">
					<div class="col angelus">
						<div class="d-block px-3 py-1 m-0 w-100 h-100 d-flex align-items-center">
							<img src="{{ asset('img/acordeon/logos/angelus_logo.png') }}" class="img-fluid mx-auto d-block w-50">
						    <div>
						    	<p class="text-white mb-0"><small>Elaborados cuidadosamente a mano con las más finas materias primas y los mejores sistemas de descanso.</small></p>
						    	<div class="text-verde-fuerte text-right position-relative">
						    	    <a href="{{ url('/angelus') }}" class="text-white border-0 btn text-uppercase raleway_bold btn-outline-verde-fuerte">Sorpréndete</a>
						    	    <i class="fas fa-arrow-right fa-lg align-middle"></i>
						    	</div>
						    </div>
						    <i class="fa-2x fas fa-angle-up position-absolute text-white"></i>
						</div>
					</div>
				</div>
				<div class="row">
					<div class="col hogar">
						<div class="d-block px-3 py-1 m-0 w-100 h-100 d-flex align-items-center">
							<img src="{{ asset('img/acordeon/logos/Hogar_logo.png') }}" class="img-fluid mx-auto d-block w-50">
						    <div>
		    				    <p class="azul mb-0"><small>Inicia tu día con un gran descanso y descubre porqué somos el colchón consentido de todo México.</small></p>
		    				    <div class="text-morado text-right position-relative">
		    	                    <a href="{{ url('/linea/hogar/gran-marques') }}" class="text-white border-0 btn text-uppercase raleway_bold btn-outline-morado">Conócenos</a>
		    	                    <i class="fas fa-arrow-right fa-lg align-middle"></i>
		    	                </div>
						    </div>
						    <i class="fa-2x fas fa-angle-up position-absolute"></i>
						</div>
					</div>
				</div>
				<div class="row">
					<div class="col fcg">
						<div class="d-block px-3 py-1 m-0 w-100 h-100 d-flex align-items-center">
							<img src="{{ asset('img/acordeon/logos/FCG_LOGO.png') }}" class="img-fluid mx-auto d-block w-50">
						    <div>
		    				    <p class="text-white mb-0"><small>Nuestro colchón de línea hotelera es insuperable, garantizando la satisfacción total de sus huéspedes.</small></p>
		    				    <div class="text-amarillo text-right position-relative">
		    	                    <a href="{{ url('/linea/hotelera') }}" class="text-white border-0 btn text-uppercase raleway_bold btn-outline-amarillo">Descúbralo</a>
		    	                    <i class="fas fa-arrow-right fa-lg align-middle"></i>
		    	               	</div>
						    </div>
						    <i class="fa-2x fas fa-angle-up position-absolute text-white"></i>
						</div>
					</div>
				</div>
				<div class="row">
					<div class="col medico">
						<div class="d-block px-3 py-1 m-0 w-100 h-100 d-flex align-items-center">
							<img src="{{ asset('img/acordeon/logos/medico_logo.png') }}" class="img-fluid mx-auto d-block w-50">
						    <div>
		    				    <p class="azul mb-0"><small>Es primordial la comodidad y el descanso que sus pacientes necesitan para una rápida recuperación.</small></p>
		    				     <div class="text-verde-claro text-right position-relative">
		    	                    <a href="{{ url('/linea/clinico') }}" class="text-white border-0 btn text-uppercase raleway_bold btn-outline-verde-claro">Confíe</a>
		    	                    <i class="fas fa-arrow-right fa-lg align-middle"></i>
		    	                </div>
						    </div>
						    <i class="fa-2x fas fa-angle-up position-absolute"></i>
						</div>
					</div>
				</div>
			</div>
		</section>

	@else
		
		<section class="ajuste_menu">
			<div class="unleash_container" id="acordion"> <!-- container -->
			    <div class="any_other_class unleash_slider"> <!-- slider -->

			        <div class="unleash_slide"> <!-- slide -->
			            <video loop muted preload="auto" poster="{{ asset('img/acordeon/angelus.jpg?v=2') }}">
			                <source src="{{ asset('video/acordeon/angelus.mp4?v=5') }}" type="video/mp4">
			            </video>
			            <img src="{{ asset('img/acordeon/angelus.jpg?v=2') }}" class="h-100" alt="Recubrimientos industriales{{ config('app.name') }}" /> <!-- slide image -->
			            <div class="unleash_caption d-block m-0"> <!-- caption -->
			                <img src="{{ asset('img/logos/angelus.svg') }}" class="mb-4">
			                <p class="text-white">Con la experiencia ganada desde el año 1970, elaboramos cuidadosamente a mano… Angelus, conjugando las más finas materias primas y los mejores sistemas de descanso, para conseguir que sueñes en “El lugar más tranquilo del mundo®”.</p>
			                <div class="text-verde-fuerte text-right">
			                    <a href="{{ url('/angelus') }}" class="text-white border-0 raleway_bold btn text-uppercase btn-outline-verde-fuerte">Sorpréndete</a>
			                    <i class="fas fa-arrow-right fa-lg align-middle"></i>
			                </div>
			            </div> <!-- end caption -->
			        </div> <!-- end slide -->

			        <div class="unleash_slide"> <!-- slide -->
			            <video loop muted preload="auto" poster="{{ asset('img/acordeon/hogar.jpg?v=5') }}">
			                <source src="{{ asset('video/acordeon/hogar.mp4?v=2') }}" type="video/mp4">
			            </video>
			            <img src="{{ asset('img/acordeon/hogar.jpg?v=5') }}" class="h-100" alt="Investigación y desarrollo {{ config('app.name') }}" /> <!-- slide image -->
			            <div class="unleash_caption d-block m-0"> <!-- caption -->
			                <img src="{{ asset('img/logos/hogar.svg') }}" class="mb-4">
			                <p class="text-white">Inicia tu día con un gran descanso y descubre porqué somos el colchón consentido de todo México. 50 años fabricando noches placenteras para días grandiosos.</p>
			                <div class="text-morado text-right">
			                    <a href="{{ url('/linea/hogar/gran-marques') }}" class="text-white border-0 raleway_bold btn text-uppercase btn-outline-morado">Conócenos</a>
			                    <i class="fas fa-arrow-right fa-lg align-middle"></i>
			                </div>
			            </div> <!-- end caption -->
			        </div> <!-- end slide -->

			        <div class="unleash_slide"> <!-- slide -->
			            <video loop muted preload="auto" poster="{{ asset('img/acordeon/fcg.jpg?v=2') }}">
			                <source src="{{ asset('video/acordeon/FCG.mp4?v=3') }}" type="video/mp4">
			            </video>
			            <img src="{{ asset('img/acordeon/fcg.jpg?v=2') }}" class="h-100" alt="Recubrimientos arquitectónicos {{ config('app.name') }}" /> <!-- slide image -->
			            <div class="unleash_caption d-block m-0"> <!-- caption -->
			                <img src="{{ asset('img/logos/FCG.svg') }}" class="mb-4">
			                <p class="text-vwhite">Nuestro colchón de línea hotelera es insuperable, fabricados con la más alta calidad en materias primas y sistemas de descanso, satisfacemos los requerimientos más exigentes de nuestros clientes hoteleros, garantizando la satisfacción total de sus huéspedes; calidad que nos ubica dentro de las mejores cadenas hoteleras alrededor del mundo.</p>
			               	<div class="text-verde-claro text-right">
			                    <a href="{{ url('/linea/hotelera') }}" class="text-white border-0 raleway_bold btn text-uppercase btn-outline-verde-claro">Descúbralo</a>
			                    <i class="fas fa-arrow-right fa-lg align-middle"></i>
			               	</div>
			            </div> <!-- end caption -->
			        </div> <!-- end slide -->

			        <div class="unleash_slide"> <!-- slide -->
			            <video loop muted preload="auto" poster="{{ asset('img/acordeon/medico.jpg?v=2') }}">
			                <source src="{{ asset('video/acordeon/medico.mp4?v=2') }}" type="video/mp4">
			            </video>
			            <img src="{{ asset('img/acordeon/medico.jpg?v=2') }}" class="h-100" alt="Servicio integral {{ config('app.name') }}" /> <!-- slide image -->
			            <div class="unleash_caption d-block m-0"> <!-- caption -->
			                <img src="{{ asset('img/logos/medico.svg') }}" class="mb-4">
			                <p class="text-white">Es primordial la comodidad y el descanso que sus pacientes necesitan para una rápida recuperación; nuestro colchón Médico Hospitalario es perfecto para esa tarea, ya que está fabricado con espumas de alta calidad que brindan una grata sensación de comodidad a sus pacientes.</p>
			                <div class="text-amarillo text-right">
			                    <a href="{{ url('/linea/clinico') }}" class="text-white border-0 raleway_bold btn text-uppercase btn-outline-amarillo">Confíe</a>
			                    <i class="fas fa-arrow-right fa-lg align-middle"></i>
			                </div>
			            </div> <!-- end caption -->
			        </div> <!-- end slide -->

			    </div> <!-- end slider -->
			</div> <!-- end container -->
		</section>

	@endif
@endsection

@section('js')
	<script src="{{ asset('js/modernizr.js') }}"></script>
	<script src="{{ asset('js/jquery.unleash.3.js') }}"></script>
	<script>
	    $(document).ready(function() {
	        $(".unleash_slider").unleash({
	            slide_width: "40%",
	            duration: 700,
	            slide_duration: 6000,
	            slideshow: false,
	            initially_open_slide: 0,
	            hide_controls: true,
	            pause_onmouseover: true,
	            open_event: 'mouseover',
	            collapse_on_mouseout: true
	        });

	        $('body').on('click', '.fa-angle-up', function(event) {
	        	event.preventDefault();
	        	$(this).removeClass('fa-angle-up').addClass('fa-angle-down');
	        	$(this).siblings('img').removeClass('d-block').fadeOut();
	        	$(this).parents('.col').addClass('h100');
	        	$(this).parents('.row').siblings('div').hide();
	        	$(this).parent('div').addClass('flex-column justify-content-end');
	        	$(this).siblings('div').slideDown();
	        });

	        $('body').on('click', '.fa-angle-down', function(event) {
	        	event.preventDefault();
	        	$(this).siblings('div').slideUp();
	        	$(this).removeClass('fa-angle-down').addClass('fa-angle-up');
	        	$(this).siblings('img').addClass('d-block').fadeIn();
	        	$(this).parents('.col').removeClass('h100');
	        	$(this).parents('.row').siblings('div').fadeIn();
	        	$(this).parent('div').removeClass('flex-column justify-content-end');
	        });
	    });
	</script>
@endsection