<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
	@php
		$titulo = "Historia Colchones Carreiro";
	@endphp
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="{{ asset('bootstrap-4/css/bootstrap.min.css') }}" >
   
	<!-- Coloca este código dentro de la etiqueta <head> de tu web -->
	<title>{{ $titulo }}</title>
	<meta name="description" content="Visita nuestro sitio y encuentra el colchón perfecto para tu descanso. Colchones Carreiro® ¡Por tradición!" />

	<!-- Twitter Card data -->
	<meta name="twitter:card" value="summary_large">

	<!-- Open Graph data -->
	<meta property="og:title" content="{{ $titulo }}" />
	<meta property="og:type" content="website" />
	<meta property="og:url" content="{{ Request::fullUrl() }}" />
	<meta property="og:image" content="{{ asset('img/historia/redes-socilales-colchones-carreiro.jpg') }}" />
	<meta property="og:description" content="Visita nuestro sitio y encuentra el colchón perfecto para tu descanso. Colchones Carreiro® ¡Por tradición!" />
	{{-- AOS Scroll --}}
    <link rel="stylesheet" href="{{ asset('aos-master/aos.css') }}">
	{{-- CSS --}}
	<link rel="stylesheet" href="{{ asset('css/fuentes.css') }}">
	<link rel="stylesheet" href="{{ asset('css/globales.css?v=1') }}">
	<link rel="stylesheet" href="{{ asset('css/historia.css') }}">
</head>
<body>
	@include('includes.header')
	<section id="cd-timeline" class="cd-container ajuste_menu">
		<div class="cd-timeline-block">
			<div class="cd-timeline-img cd-picture">
				{{-- <img src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/148866/cd-icon-picture.svg" alt="Picture"> --}}
			</div> <!-- cd-timeline-img -->

			<div class="cd-timeline-content" data-aos="fade-right">
				<h2 class="azul">NUESTRO NACIMIENTO</h2>
				<p class="azul">En la década de los 70's en CDMX nace una pequeña fábrica de colchones tomando como punto de partida, un local de 700 m2.</p>
				<img src="{{ asset('img/historia/nuestro-nacimiento-colchones-carreiro.jpg') }}" alt="Nuestro Nacimiento {{ $titulo }}" class="img-fluid mx-auto d-block">
				{{-- <a href="#0" class="cd-read-more">Read more</a> --}}
				<span class="cd-date azul">Década de los 70's</span>
			</div> <!-- cd-timeline-content -->
		</div> <!-- cd-timeline-block -->

		<div class="cd-timeline-block">
			<div class="cd-timeline-img cd-movie">
				{{-- <img src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/148866/cd-icon-movie.svg" alt="Movie"> --}}
			</div> <!-- cd-timeline-img -->

			<div class="cd-timeline-content" data-aos="fade-left">
				<h2 class="azul">CRECIENDO DÍA A DÍA</h2>
				<p class="azul">Es a partir de esta década, en  que Colchones Carreiro empieza a crecer continuamente en personal, unidades de transporte, bodegas, maquinaria y se renta una bodega continua de otros 700 m2.</p>
				<img src="{{ asset('img/historia/creciendo-dia-a-dia-colchones-carreiro.jpg') }}" alt="Creciendo dia a Dia {{ $titulo }}" class="img-fluid mx-auto d-block">
				{{-- <a href="#0" class="cd-read-more">Read more</a> --}}
				<span class="cd-date azul">Década de los 80's</span>
			</div> <!-- cd-timeline-content -->
		</div> <!-- cd-timeline-block -->

		<div class="cd-timeline-block">
			<div class="cd-timeline-img cd-picture">
				{{-- <img src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/148866/cd-icon-picture.svg" alt="Picture"> --}}
			</div> <!-- cd-timeline-img -->

			<div class="cd-timeline-content" data-aos="fade-right">
				<h2 class="azul">CON PASO FIRME</h2>
				<p class="azul">El 24 de Junio de 1994 se inician labores en las instalaciones actuales de Colchones Carreiro.</p>
				<img src="{{ asset('img/historia/con-paso-firme-colchones-carreiro.jpg') }}" alt="Con Paso Firme {{ $titulo }}" class="img-fluid mx-auto d-block">
				{{-- <a href="#0" class="cd-read-more">Read more</a> --}}
				<span class="cd-date azul">Década de los 90's</span>
			</div> <!-- cd-timeline-content -->
		</div> <!-- cd-timeline-block -->

		<div class="cd-timeline-block">
			<div class="cd-timeline-img cd-movie">
				{{-- <img src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/148866/cd-icon-location.svg" alt="Location"> --}}
			</div> <!-- cd-timeline-img -->

			<div class="cd-timeline-content" data-aos="fade-left">
				<h2 class="azul">TECNOLOGÍA DE PUNTA</h2>
				<p class="azul">Se establece un sistema automatizado de producción, contamos con maquinaria de última tecnología. Tenemos una de las plantas automatizadas más importantes del país.</p>
				<img src="{{ asset('img/historia/tecnologia-de-punta-colchones-carreiro.jpg') }}" alt="tecnologia de punta {{ $titulo }}" class="img-fluid mx-auto d-block">
				{{-- <a href="#0" class="cd-read-more">Read more</a> --}}
				<span class="cd-date azul">Los 2000</span>
			</div> <!-- cd-timeline-content -->
		</div> <!-- cd-timeline-block -->

		<div class="cd-timeline-block">
			<div class="cd-timeline-img cd-location">
				{{-- <img src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/148866/cd-icon-location.svg" alt="Location"> --}}
			</div> <!-- cd-timeline-img -->

			<div class="cd-timeline-content" data-aos="fade-right">
				<h2 class="azul">SATISFACCIÓN TOTAL</h2>
				<p class="azul">Colchones Carreiro sigue creciendo, abriendo sus puertas con sucursales en diferentes estados de la República Mexicana. Teniendo presencia, no sólo en México, sino en otros países.</p>
				<img src="{{ asset('img/historia/satisfaccion-total-colchones-carreiro.jpg') }}" alt="satisfacción Total {{ $titulo }}" class="img-fluid mx-auto d-block">
				{{-- <a href="#0" class="cd-read-more">Read more</a> --}}
				<span class="cd-date azul">ACTUALIDAD</span>
			</div> <!-- cd-timeline-content -->
		</div> <!-- cd-timeline-block -->

		{{-- <div class="cd-timeline-block">
			<div class="cd-timeline-img cd-movie">
				<img src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/148866/cd-icon-movie.svg" alt="Movie">
			</div> <!-- cd-timeline-img -->

			<div class="cd-timeline-content" data-aos="fade-left">
				<h2 class="azul">Final Section</h2>
				<p class="azul">This is the content of the last section</p>
				<span class="cd-date azul">Feb 26</span>
			</div> <!-- cd-timeline-content -->
		</div> <!-- cd-timeline-block --> --}}
	</section> <!-- cd-timeline -->
	@include('includes.footer')
	<!-- jQuery first, then Popper.js, then Bootstrap JS -->
    <script src="{{ asset('jquery/jquery-3.3.1.min.js') }}"></script>
    <script src="{{ asset('popper/popper.min.js') }}"></script>
    <script src="{{ asset('bootstrap-4/js/bootstrap.min.js') }}"></script>
    {{-- Font Awesome --}}
    <script src="{{ asset('font-awesome-5.0.8/all.js') }}"></script>
	{{-- AOS Scroll --}}
    <script src="{{ asset('aos-master/aos.js') }}"></script>
    {{-- JS --}}
    <script src="{{ asset('js/globales.js') }}"></script>
    <script src="{{ asset('js/historia.js') }}"></script>
    <script>var path = '{{ Request::root() }}';</script>
</body>
</html>