@extends('layout')

@section('css')
	<link href="https://vjs.zencdn.net/7.8.4/video-js.css" rel="stylesheet" />}
	<!-- If you'd like to support IE8 (for Video.js versions prior to v7) -->
	<script src="https://vjs.zencdn.net/ie8/1.1.2/videojs-ie8.min.js"></script>
	<style>
		#btn-saltar {
			right: 50px;
			bottom: 50px;
			border-radius: 30px;
		}
	</style>
@endsection

@section('contenido')
	<div class="position-relative">
		<video
		   id="my-video-desktop"
		   class="video-js vjs-fluid"
		   preload="auto"
		   autoplay
		   muted
		   poster="MY_VIDEO_POSTER.jpg"
		   data-setup="{}"
		   onended="window.location.href = '{{ url('/linea/hogar/gran-marques') }}'"
		   >
		   @if ($agent->isMobile())
		   		<source src="{{ asset('video/intro-hogar-mobile.mp4') }}" type="video/mp4" />
		   @else
		   		<source src="{{ asset('video/intro-hogar-desktop.mp4') }}" type="video/mp4" />
		   @endif
		   {{-- <source src="MY_VIDEO.webm" type="video/webm" /> --}}
		</video>
		<button class="position-absolute btn btn-outline-dark" id="btn-saltar" onclick="window.location.href = '{{ url('/linea/hogar/gran-marques') }}'">Saltar intro <i class="fas fa-chevron-right"></i></button>
	</div>
@endsection

@section('js')
	<script src="https://vjs.zencdn.net/7.8.4/video.js"></script>
@endsection