<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="{{ asset('bootstrap-4/css/bootstrap.min.css') }}" >
    {{-- Animate CSS --}}
    <link rel="stylesheet" href="{{ asset('animate-css/animate.css') }}">
	<!-- Coloca este código dentro de la etiqueta <head> de tu web -->
	<title>@yield('titulo') | Colchones Carreiro</title>
	<meta name="description" content="@yield('descripcion')" />

	<!-- Twitter Card data -->
	<meta name="twitter:card" value="summary_large">

	<!-- Open Graph data -->
	<meta property="og:title" content="@yield('titulo') | Colchones Carreiro" />
	<meta property="og:type" content="website" />
	<meta property="og:url" content="{{ Request::fullUrl() }}" />
	<meta property="og:image" content="@yield('imagen')" />
	<meta property="og:description" content="@yield('descripcion')" />
	{{-- CSS --}}
	<link rel="stylesheet" href="{{ asset('css/fuentes.css?v=2') }}">
	<link rel="stylesheet" href="{{ asset('css/globales.css?v=1') }}">
	@yield('css')
</head>
<body>
	<div id="loader"></div>
	@include('includes.header')
	@yield('contenido')
	@include('includes.footer')
	<!-- jQuery first, then Popper.js, then Bootstrap JS -->
    <script src="{{ asset('jquery/jquery-3.3.1.min.js') }}"></script>
    <script src="{{ asset('popper/popper.min.js') }}"></script>
    <script src="{{ asset('bootstrap-4/js/bootstrap.min.js') }}"></script>
    {{-- Font Awesome --}}
    <script src="{{ asset('font-awesome-5.0.8/all.js') }}"></script>
    @yield('js')
    {{-- JS --}}
    <script src="{{ asset('js/globales.js') }}"></script>
    <script>var path = '{{ Request::root() }}';</script>
    <script>
    	$('.scroll').click(function(event) {
    		event.preventDefault();
    		console.log('scroll')
    		var target = $(this).attr('href');
    		$('html, body').animate({
    			scrollTop: $(target).offset().top -66
    		}, 800);
    	});
    </script>
</body>
</html>