<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>">
<head>
	<?php
		$titulo = "Linea Hotelera | Colchones Carreiro";
		$descripcion = "Fabricamos colchones para hoteles. Colchones para su hotel a precios muy accesibles. Colchones a la medida de las necesidades de su hotel, que harán que sus huéspedes regresen.";
	?>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('bootstrap-4/css/bootstrap.min.css')); ?>" >
    
    <link rel="stylesheet" href="<?php echo e(asset('slick-1.8.0/slick.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('slick-1.8.0/slick-theme.css')); ?>">
	<!-- Coloca este código dentro de la etiqueta <head> de tu web -->
	<title><?php echo e($titulo); ?></title>
	<meta name="description" content="<?php echo e($descripcion); ?>" />

	<!-- Twitter Card data -->
	<meta name="twitter:card" value="summary_large">

	<!-- Open Graph data -->
	<meta property="og:title" content="<?php echo e($titulo); ?>" />
	<meta property="og:type" content="website" />
	<meta property="og:url" content="<?php echo e(Request::fullUrl()); ?>" />
	<meta property="og:image" content="<?php echo e(asset('img/logos/imagotipo-azul-colchones-carreiro.png')); ?>" />
	<meta property="og:description" content="<?php echo e($descripcion); ?>" />
	
	
	
	<link rel="stylesheet" type="text/css" href="<?php echo e(asset('slider-revolution/revolution/fonts/pe-icon-7-stroke/css/pe-icon-7-stroke.css')); ?>">
	<link rel="stylesheet" type="text/css" href="<?php echo e(asset('slider-revolution/revolution/fonts/font-awesome/css/font-awesome.css')); ?>">    
    <!-- REVOLUTION STYLE SHEETS -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('slider-revolution/revolution/css/settings.css')); ?>">
    <!-- REVOLUTION LAYERS STYLES -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('slider-revolution/revolution/css/layers.css')); ?>">            
    <!-- REVOLUTION NAVIGATION STYLES -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('slider-revolution/revolution/css/navigation.css')); ?>">
    
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('slider-revolution/revolution-addons/particles/css/revolution.addon.particles.css')); ?>" />



	
	<link rel="stylesheet" href="<?php echo e(asset('slick-1.8.0/slick.css')); ?>">
	
	<link rel="stylesheet" href="<?php echo e(asset('Justified-Gallery/css/justifiedGallery.min.css')); ?>">
	
	<link rel="stylesheet" href="<?php echo e(asset('css/fuentes.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('css/globales.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('css/hotelero.css')); ?>">
</head>
<body>
	<div id="loader" class="d-flex align-items-center justify-content-center">
		<div>
			<img src="<?php echo e(asset("img/logos/isologo-linea-$linea-colchones-carreiro.svg")); ?>" alt="<?php echo e($titulo); ?>" class="img-fluid mx-auto d-block" width="200">
			<img src="<?php echo e(asset('img/loader.svg')); ?>" alt="<?php echo e($titulo); ?>" class="img-fluid mx-auto d-block" width="100">
		</div>
	</div>
	<?php echo $__env->make('includes.header', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
	<section id="hotelero" class="ajuste_menu d-flex align-items-center">
		<div class="container">
			<div class="row align-items-center">
				<div class="col-sm col-md-4">
					<img src="<?php echo e(asset('img/logos/isologo-linea-hotelera-colchones-carreiro.svg')); ?>" alt="Line Hotelera Colchones Carreiro" class="img-fluid mx-auto d-block my-3">
					<p class="raleway_bold azul text-justify" style="line-height: 1.2"><small>¿Quiere ser un gran hotel? Los mejores hoteles saben de la importancia de ofrecer un gran descanso a sus huéspedes. Contáctenos, juntos haremos que su hotel brinde la mejor de las experiencias</small></p>
					<h2 class="raleway_regular h3 mb-0 pl-3 azul">HOTELERO</h2>
					<div class="carousel-slick slider-aux" id="slider-descripcion">
						<div>
							<h1 class="h3 azul raleway_regular text-right text-uppercase pr-3"><strong>DREAM MAKER</strong></h1>
							<p class="raleway_regular text-justify azul" style="line-height: 1.2;"><small>Nuestra propuesta de diseño para colchón de hoteles se basa en hacer un colchón a la medida de sus necesidades, superando cualquier expectativa. Sabemos que los huéspedes tendrán un descanso adecuado y querrán volver a su hotel.</small></p>
						</div>
						<div>
							<h1 class="h3 azul raleway_regular text-right text-uppercase pr-3"><strong>Fluffy</strong></h1>
							<p class="raleway_regular text-justify azul" style="line-height: 1.2;"><small>.Contamos con colchones para hoteles a precios muy competitivos. Contáctenos, con gusto podemos elaborar una cotización de los colchones ideales para su hotel de acuerdo a su presupuesto.</small></p>
						</div>
						<div>
							<h1 class="h3 azul raleway_regular text-right text-uppercase pr-3"><strong>Gran Duque</strong></h1>
							<p class="raleway_regular text-justify azul" style="line-height: 1.2;"><small>.Nuestros colchones son sinónimo de satisfacción y descanso. ¿Le gustaría ofrecer a sus huéspedes el mejor lugar para descansar durante su visita? Somos su mejor opción de colchón hotelero.</small></p>
						</div>
						<div>
							<h1 class="h3 azul raleway_regular text-right text-uppercase pr-3"><strong>Tender Dreams</strong></h1>
							<p class="raleway_regular text-justify azul" style="line-height: 1.2;"><small>Nuestros colchones son sinónimo de satisfacción y descanso. ¿Le gustaría ofrecer a sus huéspedes el mejor lugar para descansar durante su visita? Somos su mejor opción de colchón hotelero.</small></p>
						</div>
					</div>
					<div class="row align-items-center">
						<div class="col">
							<img src="<?php echo e(asset('img/iconos/garantia-colchones-carreiro.svg')); ?>" alt="Line Hotelera Colchones Carreiro" class="img-fluid mx-auto d-block" width="100">
						</div>
						<div class="col">
							<button class="btn btn-primary" data-toggle="modal" data-target="#modal-contacto"><i class="fa fa-envelope" aria-hidden="true"></i> <small>CONTÁCTENOS</small></button>
						</div>
					</div>
				</div>
				<div class="col-sm col-md-7 offset-lg-1 pr-0">
					<div class="carousel-slick" id="slider-imagen">
						<div>
							<img src="<?php echo e(asset('img/colchones/hotelero/dream-maker-linea-hotelero-colchones-carreiro.png')); ?>" alt="Colchon Dream Maker Line Hotelera Colchones Carreiro" class="img-fluid mx-auto d-block imagen-abierta" data-abierta="<?php echo e(asset('img/colchones/hotelero/abierto-dream-maker-linea-hotelero-colchones-carreiro.png')); ?>" data-original="<?php echo e(asset('img/colchones/hotelero/dream-maker-linea-hotelero-colchones-carreiro.png')); ?>">
							<i class="fas fa-plus" data-toggle="modal" data-target="#modal-imagen-alta" data-alta="<?php echo e(asset('img/colchones/hotelero/alta/dream-maker.png')); ?>"></i>
						</div>
						<div>
							<img src="<?php echo e(asset('img/colchones/hotelero/fluffy-linea-hogar-colchones-carreiro.png')); ?>" alt="Colchon Fluffy Line Hotelera Colchones Carreiro" class="img-fluid mx-auto d-block imagen-abierta" data-abierta="<?php echo e(asset('img/colchones/hotelero/abierto-fluffy-linea-hogar-colchones-carreiro.png')); ?>" data-original="<?php echo e(asset('img/colchones/hotelero/fluffy-linea-hogar-colchones-carreiro.png')); ?>">
							<i class="fas fa-plus" data-toggle="modal" data-target="#modal-imagen-alta" data-alta="<?php echo e(asset('img/colchones/hotelero/alta/fluffy.png')); ?>"></i>
						</div>
						<div>
							<img src="<?php echo e(asset('img/colchones/hotelero/gran-duque-linea-hotelero-colchones-carreiro.png')); ?>" alt="Colchon Gran Duque Line Hotelera Colchones Carreiro" class="img-fluid mx-auto d-block imagen-abierta" data-abierta="<?php echo e(asset('img/colchones/hotelero/abierto-gran-duque-linea-hotelero-colchones-carreiro.png')); ?>" data-original="<?php echo e(asset('img/colchones/hotelero/gran-duque-linea-hotelero-colchones-carreiro.png')); ?>">
							<i class="fas fa-plus" data-toggle="modal" data-target="#modal-imagen-alta" data-alta="<?php echo e(asset('img/colchones/hotelero/alta/hotelero-gran-duque.png')); ?>"></i>
						</div>
						<div>
							<img src="<?php echo e(asset('img/colchones/hotelero/tender-dreams-linea-hotelero-colchones-carreiro.png')); ?>" alt="Colchon Tender Dreams Line Hotelera Colchones Carreiro" class="img-fluid mx-auto d-block imagen-abierta" data-abierta="<?php echo e(asset('img/colchones/hotelero/abierto-tender-dreams-linea-hotelero-colchones-carreiro.png')); ?>" data-original="<?php echo e(asset('img/colchones/hotelero/tender-dreams-linea-hotelero-colchones-carreiro.png')); ?>">
							<i class="fas fa-plus" data-toggle="modal" data-target="#modal-imagen-alta" data-alta="<?php echo e(asset('img/colchones/hotelero/alta/tender-dreams.png')); ?>"></i>
						</div>
					</div>
					<div class="row" id="carousel-mini">
						<div class="col">
							<img src="<?php echo e(asset('img/colchones/hotelero/dream-maker-linea-hotelero-colchones-carreiro.png')); ?>" alt="Dream Maker <?php echo e($titulo); ?>" class="img-fluid mx-auto d-block">
						</div>
						<div class="col">
							<img src="<?php echo e(asset('img/colchones/hotelero/fluffy-linea-hogar-colchones-carreiro.png')); ?>" alt="Fluffy <?php echo e($titulo); ?>" class="img-fluid mx-auto d-block">
						</div>
						<div class="col">
							<img src="<?php echo e(asset('img/colchones/hotelero/gran-duque-linea-hotelero-colchones-carreiro.png')); ?>" alt="Gran Duque <?php echo e($titulo); ?>" class="img-fluid mx-auto d-block">
						</div>
						<div class="col">
							<img src="<?php echo e(asset('img/colchones/hotelero/tender-dreams-linea-hotelero-colchones-carreiro.png')); ?>" alt="Tender Dreams <?php echo e($titulo); ?>" class="img-fluid mx-auto d-block">
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- SLIDER EXAMPLE -->
    <section class="example" id="slider-revolution-hotelero">
    	<div class="container-fluid">
    		<div class="row">
    			<div class="col pb-3">
    				<h2 class="ralewal_bold text-uppercase azul text-center h3 mx-auto px-3"><span class="raleway_light">Nuestros sistemas de </span>descanso</h2>
    				<hr>
    			</div>
    		</div>
    	</div>
        <article class="content">

			<div id="rev_slider_1082_1_wrapper" class="rev_slider_wrapper fullwidthbanner-container" data-alias="team" data-source="gallery" style="margin:0px auto;background-color:#000000;padding:0px;margin-top:0px;margin-bottom:0px;">
				<!-- START REVOLUTION SLIDER 5.4.1 auto mode -->
			    <div id="rev_slider_1082_1" class="rev_slider fullwidthabanner" style="display:none;" data-version="5.4.1">
					<ul>    <!-- SLIDE  -->
				  		<li data-index="rs-3063" data-transition="fade" data-slotamount="default" data-fsslotamount="10" data-hideafterloop="0" data-hideslideonmobile="off"  data-easein="Power1.easeInOut" data-easeout="Power1.easeInOut" data-masterspeed="500"  data-rotate="0"  data-fstransition="fade" data-fsmasterspeed="500" data-saveperformance="off"  data-title="First" data-param1="" data-param2="" data-param3="" data-param4="" data-param5="" data-param6="" data-param7="" data-param8="" data-param9="" data-param10="" data-description="">
					        <!-- MAIN IMAGE -->
					        <img src="<?php echo e(asset('slider-revolution/assets/images/transparent.png')); ?>"  alt="" class="rev-slidebg" style="background-color: black;">
					        <!-- LAYERS -->

					        <!-- LAYER NR. 1 -->
					        <div class="tp-caption tp-shape tp-shapewrapper " 
					            id="slide-3063-layer-4" 
					            data-x="['center','center','center','center']" data-hoffset="['0','0','0','0']" 
					            data-y="['middle','middle','middle','middle']" data-voffset="['0','0','0','0']" 
					            data-width="full"
					            data-height="full"
					            data-whitespace="nowrap"
					 
					            data-type="shape" 
					            data-basealign="slide" 
					            data-responsive_offset="off" 
					            data-responsive="off"
					            data-frames='[{"from":"opacity:0;","speed":500,"to":"o:1;","delay":500,"ease":"Power1.easeInOut"},{"delay":"wait","speed":1000,"to":"opacity:0;","ease":"nothing"}]'
					            data-textAlign="['left','left','left','left']"
					            data-paddingtop="[0,0,0,0]"
					            data-paddingright="[0,0,0,0]"
					            data-paddingbottom="[0,0,0,0]"
					            data-paddingleft="[0,0,0,0]"

					            style="z-index: 5;text-transform:left;background-color:rgba(0, 0, 0, 0.25);border-color:rgba(0, 0, 0, 0.50);border-width:0px;"> </div>

					        <!-- LAYER NR. 2 -->
					        <div class="tp-caption Team-Name tp-resizeme raleway_regular text-uppercase" 
					            id="slide-3063-layer-1" 
					            data-x="['center']" data-hoffset="['0']" 
					            data-y="['top','top','top','top']" data-voffset="['140','250','220','200']" 
					            data-fontsize="['30','30','25','20']"
					            data-lineheight="['70','70','50','50']"
					            data-width="none"
					            data-height="none"
					            data-whitespace="nowrap"
					 
					            data-type="text" 
					            data-responsive_offset="on" 

					            data-frames='[{"from":"x:-50px;opacity:0;","speed":500,"to":"o:1;","delay":0,"ease":"Power1.easeInOut"},{"delay":"wait","speed":500,"to":"x:50px;opacity:0;","ease":"Power1.easeInOut"}]'
					            data-textAlign="['left','left','left','left']"
					            data-paddingtop="[0,0,0,0]"
					            data-paddingright="[0,0,0,0]"
					            data-paddingbottom="[0,0,0,0]"
					            data-paddingleft="[0,0,0,0]"

					            style="z-index: 6; white-space: nowrap;text-transform:left;">SISTEMA <span style="font-size: 2em;">Comfort Tech</span></div>


					        <!-- LAYER NR. 4 -->
					        <div class="tp-caption Team-Description tp-resizeme raleway_regular" 
					            id="slide-3063-layer-3" 
					            data-x="['center']" data-hoffset="['0']" 
					            data-y="['top','top','top','top']" data-voffset="['210','400','320','300']" 
					            data-fontsize="['18','18','15','15']"
					            data-lineheight="['28','28','25','25']"
					            data-width="['640','640','640','360']"
					            data-height="none"
					            data-whitespace="normal"
					 
					            data-type="text" 
					            data-responsive_offset="on" 

					            data-frames='[{"from":"x:-50px;opacity:0;","speed":500,"to":"o:1;rZ:360;","delay":500,"ease":"Power1.easeInOut"},{"delay":"wait","speed":500,"to":"x:50px;opacity:0;","ease":"Power1.easeInOut"}]'
					            data-textAlign="['left','left','left','left']"
					            data-paddingtop="[0,0,0,0]"
					            data-paddingright="[0,0,0,0]"
					            data-paddingbottom="[0,0,0,0]"
					            data-paddingleft="[0,0,0,0]"

					            style="z-index: 8; min-width: 640px; max-width: 640px; white-space: normal;text-transform:left;">
					            	UNIDAD DE RESORTES:<br>LFK Sistema Cosiflex de 6 vueltas de alambre de acero de alto carbono calibre 14, ensamblados con gusanillo de alambre calibrado 17, marco perimetral calibre 6, engrapado y doble templado (Termoflex), más estabilizadores perimetrales.
					            </div>

					    </li>
					    <!-- SLIDE  -->
					    <li data-index="rs-3064" data-transition="fade" data-slotamount="default" data-hideafterloop="0" data-hideslideonmobile="off"  data-easein="Power1.easeInOut" data-easeout="Power1.easeInOut" data-masterspeed="500"  data-rotate="0"  data-saveperformance="off"  data-title="Second" data-param1="" data-param2="" data-param3="" data-param4="" data-param5="" data-param6="" data-param7="" data-param8="" data-param9="" data-param10="" data-description="">
					        <!-- MAIN IMAGE -->
					        <img src="<?php echo e(asset('slider-revolution/assets/images/transparent.png')); ?>"  alt="" class="rev-slidebg" style="background-color: black;">
					        <!-- LAYERS -->

					        <!-- LAYER NR. 9 -->
					        <div class="tp-caption tp-shape tp-shapewrapper " 
					            id="slide-3064-layer-4" 
					            data-x="['center','center','center','center']" data-hoffset="['0','0','0','0']" 
					            data-y="['middle','middle','middle','middle']" data-voffset="['0','0','0','0']" 
					            data-width="full"
					            data-height="full"
					            data-whitespace="nowrap"
					 
					            data-type="shape" 
					            data-basealign="slide" 
					            data-responsive_offset="off" 
					            data-responsive="off"
					            data-frames='[{"from":"opacity:0;","speed":500,"to":"o:1;","delay":500,"ease":"Power1.easeInOut"},{"delay":"wait","speed":1000,"to":"opacity:0;","ease":"nothing"}]'
					            data-textAlign="['left','left','left','left']"
					            data-paddingtop="[0,0,0,0]"
					            data-paddingright="[0,0,0,0]"
					            data-paddingbottom="[0,0,0,0]"
					            data-paddingleft="[0,0,0,0]"

					            style="z-index: 13;text-transform:left;background-color:rgba(0, 0, 0, 0.25);border-color:rgba(0, 0, 0, 0.50);border-width:0px;"> </div>

					        <!-- LAYER NR. 10 -->
					        <div class="tp-caption Team-Name tp-resizeme raleway_regular text-uppercase" 
					            id="slide-3064-layer-1" 
					            data-x="['center']" data-hoffset="['0']" 
					            data-y="['top','top','top','top']" data-voffset="['140','250','220','200']" 
					            data-fontsize="['30','30','25','20']"
					            data-lineheight="['70','70','50','50']"
					            data-width="none"
					            data-height="none"
					            data-whitespace="nowrap"
					 
					            data-type="text" 
					            data-responsive_offset="on" 

					            data-frames='[{"from":"x:-50px;opacity:0;","speed":500,"to":"o:1;","delay":0,"ease":"Power1.easeInOut"},{"delay":"wait","speed":500,"to":"x:50px;opacity:0;","ease":"Power1.easeInOut"}]'
					            data-textAlign="['left','left','left','left']"
					            data-paddingtop="[0,0,0,0]"
					            data-paddingright="[0,0,0,0]"
					            data-paddingbottom="[0,0,0,0]"
					            data-paddingleft="[0,0,0,0]"

					            style="z-index: 14; white-space: nowrap;text-transform:left;">SISTEMA <span style="font-size: 2em;">Flame Proof</span></div>


					        <!-- LAYER NR. 12 -->
					        <div class="tp-caption Team-Description tp-resizeme raleway_regular" 
					            id="slide-3064-layer-3" 
					            data-x="['center']" data-hoffset="['0']" 
					            data-y="['top','top','top','top']" data-voffset="['210','400','320','300']" 
					            data-fontsize="['18','18','15','15']"
					            data-lineheight="['28','28','25','25']"
					            data-width="['640','640','640','360']"
					            data-height="none"
					            data-whitespace="normal"
					 
					            data-type="text" 
					            data-responsive_offset="on" 

					            data-frames='[{"from":"x:-50px;opacity:0;","speed":500,"to":"o:1;rZ:360;","delay":500,"ease":"Power1.easeInOut"},{"delay":"wait","speed":500,"to":"x:50px;opacity:0;","ease":"Power1.easeInOut"}]'
					            data-textAlign="['left','left','left','left']"
					            data-paddingtop="[0,0,0,0]"
					            data-paddingright="[0,0,0,0]"
					            data-paddingbottom="[0,0,0,0]"
					            data-paddingleft="[0,0,0,0]"

					            style="z-index: 16; min-width: 640px; max-width: 640px; white-space: normal;text-transform:left;">Fibra con sales minerales, inhibidora de la flama, producto cerrado con hilo Kevlar en el bies, para reforzar el retardante al fuego.
					            <p style="color: red;" class="raleway_bold mb-1 mt-3">Normas ignífugas</p>
					            <ul class="list-unstyled">
					            	<li>Norma TB 603.</li>
					            	<li>CFR 1632 (contra flama abierta)</li>
					            	<li>CFR 1633 (contra ignición de cigarro)</li>
					            </ul>
					        </div>

					    </li>
					    <!-- SLIDE  -->
					    <li data-index="rs-3065" data-transition="fade" data-slotamount="default" data-hideafterloop="0" data-hideslideonmobile="off"  data-easein="Power1.easeInOut" data-easeout="Power1.easeInOut" data-masterspeed="500"  data-rotate="0"  data-saveperformance="off"  data-title="Third" data-param1="" data-param2="" data-param3="" data-param4="" data-param5="" data-param6="" data-param7="" data-param8="" data-param9="" data-param10="" data-description="">
					        <!-- MAIN IMAGE -->
					        <img src="<?php echo e(asset('slider-revolution/assets/images/transparent.png')); ?>"  alt="" class="rev-slidebg" style="background-color: black;">
					        <!-- LAYERS -->

					        <!-- LAYER NR. 17 -->
					        <div class="tp-caption tp-shape tp-shapewrapper " 
					            id="slide-3065-layer-4" 
					            data-x="['center','center','center','center']" data-hoffset="['0','0','0','0']" 
					            data-y="['middle','middle','middle','middle']" data-voffset="['0','0','0','0']" 
					            data-width="full"
					            data-height="full"
					            data-whitespace="nowrap"
					 
					            data-type="shape" 
					            data-basealign="slide" 
					            data-responsive_offset="off" 
					            data-responsive="off"
					            data-frames='[{"from":"opacity:0;","speed":500,"to":"o:1;","delay":500,"ease":"Power1.easeInOut"},{"delay":"wait","speed":1000,"to":"opacity:0;","ease":"nothing"}]'
					            data-textAlign="['left','left','left','left']"
					            data-paddingtop="[0,0,0,0]"
					            data-paddingright="[0,0,0,0]"
					            data-paddingbottom="[0,0,0,0]"
					            data-paddingleft="[0,0,0,0]"

					            style="z-index: 21;text-transform:left;background-color:rgba(0, 0, 0, 0.25);border-color:rgba(0, 0, 0, 0.50);border-width:0px;"> </div>

					        <!-- LAYER NR. 18 -->
					        <div class="tp-caption Team-Name tp-resizeme raleway_regular text-uppercase" 
					            id="slide-3065-layer-1" 
					            data-x="['center']" data-hoffset="['0']" 
					            data-y="['top','top','top','top']" data-voffset="['140','250','220','200']" 
					            data-fontsize="['30','30','25','20']"
					            data-lineheight="['70','70','50','50']"
					            data-width="none"
					            data-height="none"
					            data-whitespace="nowrap"
					 
					            data-type="text" 
					            data-responsive_offset="on" 

					            data-frames='[{"from":"x:-50px;opacity:0;","speed":500,"to":"o:1;","delay":0,"ease":"Power1.easeInOut"},{"delay":"wait","speed":500,"to":"x:50px;opacity:0;","ease":"Power1.easeInOut"}]'
					            data-textAlign="['left','left','left','left']"
					            data-paddingtop="[0,0,0,0]"
					            data-paddingright="[0,0,0,0]"
					            data-paddingbottom="[0,0,0,0]"
					            data-paddingleft="[0,0,0,0]"

					            style="z-index: 22; white-space: nowrap;text-transform:left;">SISTEMA <span style="font-size: 2em;">High Resistance</span></div>


					        <!-- LAYER NR. 20 -->
					        <div class="tp-caption Team-Description tp-resizeme raleway_regular" 
					            id="slide-3065-layer-3" 
					            data-x="['center']" data-hoffset="['0']" 
					            data-y="['top','top','top','top']" data-voffset="['210','400','320','300']" 
					            data-fontsize="['18','18','15','15']"
					            data-lineheight="['28','28','25','25']"
					            data-width="['640','640','640','360']"
					            data-height="none"
					            data-whitespace="normal"
					 
					            data-type="text" 
					            data-responsive_offset="on" 

					            data-frames='[{"from":"x:-50px;opacity:0;","speed":500,"to":"o:1;rZ:360;","delay":500,"ease":"Power1.easeInOut"},{"delay":"wait","speed":500,"to":"x:50px;opacity:0;","ease":"Power1.easeInOut"}]'
					            data-textAlign="['left','left','left','left']"
					            data-paddingtop="[0,0,0,0]"
					            data-paddingright="[0,0,0,0]"
					            data-paddingbottom="[0,0,0,0]"
					            data-paddingleft="[0,0,0,0]"

					            style="z-index: 24; min-width: 640px; max-width: 640px; white-space: normal;text-transform:left;">
					            UNIDAD DE RESORTES:<br>Tipo Bonell con 6 vueltas de alambre calibre 13.5 ensamblado con gusanillo de alambre  calibre 17 y marco perimetral calibre 6 engrapado y doble templado (Termoflex), más estabilizadores perimetrales
					            	
					            </div>

					    </li>
					    <!-- SLIDE  -->
					    <li data-index="rs-3066" data-transition="fade" data-slotamount="default" data-hideafterloop="0" data-hideslideonmobile="off"  data-easein="Power1.easeInOut" data-easeout="Power1.easeInOut" data-masterspeed="500"  data-rotate="0"  data-saveperformance="off"  data-title="Fourth" data-param1="" data-param2="" data-param3="" data-param4="" data-param5="" data-param6="" data-param7="" data-param8="" data-param9="" data-param10="" data-description="">
					        <!-- MAIN IMAGE -->
					        <img src="<?php echo e(asset('slider-revolution/assets/images/transparent.png')); ?>"  alt="" class="rev-slidebg" style="background-color: black;">
					        <!-- LAYERS -->

					        <!-- LAYER NR. 25 -->
					        <div class="tp-caption tp-shape tp-shapewrapper " 
					             id="slide-3066-layer-4" 
					             data-x="['center','center','center','center']" data-hoffset="['0','0','0','0']" 
					             data-y="['middle','middle','middle','middle']" data-voffset="['0','0','0','0']" 
					                        data-width="full"
					            data-height="full"
					            data-whitespace="nowrap"
					 
					            data-type="shape" 
					            data-basealign="slide" 
					            data-responsive_offset="off" 
					            data-responsive="off"
					            data-frames='[{"from":"opacity:0;","speed":500,"to":"o:1;","delay":500,"ease":"Power1.easeInOut"},{"delay":"wait","speed":1000,"to":"opacity:0;","ease":"nothing"}]'
					            data-textAlign="['left','left','left','left']"
					            data-paddingtop="[0,0,0,0]"
					            data-paddingright="[0,0,0,0]"
					            data-paddingbottom="[0,0,0,0]"
					            data-paddingleft="[0,0,0,0]"

					            style="z-index: 29;text-transform:left;background-color:rgba(0, 0, 0, 0.25);border-color:rgba(0, 0, 0, 0.50);border-width:0px;"> </div>

					        <!-- LAYER NR. 26 -->
					        <div class="tp-caption Team-Name tp-resizeme raleway_regular text-uppercase" 
					             id="slide-3066-layer-1" 
					             data-x="['center']" data-hoffset="['0']" 
					             data-y="['top','top','top','top']" data-voffset="['140','250','220','200']" 
					                        data-fontsize="['30','30','25','20']"
					            data-lineheight="['70','70','50','50']"
					            data-width="none"
					            data-height="none"
					            data-whitespace="nowrap"
					 
					            data-type="text" 
					            data-responsive_offset="on" 

					            data-frames='[{"from":"x:-50px;opacity:0;","speed":500,"to":"o:1;","delay":0,"ease":"Power1.easeInOut"},{"delay":"wait","speed":500,"to":"x:50px;opacity:0;","ease":"Power1.easeInOut"}]'
					            data-textAlign="['left','left','left','left']"
					            data-paddingtop="[0,0,0,0]"
					            data-paddingright="[0,0,0,0]"
					            data-paddingbottom="[0,0,0,0]"
					            data-paddingleft="[0,0,0,0]"

					            style="z-index: 30; white-space: nowrap;text-transform:left;">SISTEMA <span style="font-size: 2em;">Multizone Technology</span></div>


					        <!-- LAYER NR. 28 -->
					        <div class="tp-caption Team-Description tp-resizeme raleway_regular" 
					             id="slide-3066-layer-3" 
					             data-x="['center']" data-hoffset="['0']" 
					             data-y="['top','top','top','top']" data-voffset="['210','400','320','300']" 
					                        data-fontsize="['18','18','15','15']"
					            data-lineheight="['28','28','25','25']"
					            data-width="['640','640','640','360']"
					            data-height="none"
					            data-whitespace="normal"
					 
					            data-type="text" 
					            data-responsive_offset="on" 

					            data-frames='[{"from":"x:-50px;opacity:0;","speed":500,"to":"o:1;rZ:360;","delay":500,"ease":"Power1.easeInOut"},{"delay":"wait","speed":500,"to":"x:50px;opacity:0;","ease":"Power1.easeInOut"}]'
					            data-textAlign="['left','left','left','left']"
					            data-paddingtop="[0,0,0,0]"
					            data-paddingright="[0,0,0,0]"
					            data-paddingbottom="[0,0,0,0]"
					            data-paddingleft="[0,0,0,0]"

					            style="z-index: 32; min-width: 640px; max-width: 640px; white-space: normal;text-transform:left;">
					            	UNIDAD DE RESORTES:<br>Unidad de resortes embolsados individualmente, que permite la independencia de movimiento, con marco perimetral de acero calibre 6, engrapado a cada resorte.
					            </div>

					    </li>
					    <!-- SLIDE  -->
					    <li data-index="rs-3067" data-transition="fade" data-slotamount="default" data-hideafterloop="0" data-hideslideonmobile="off"  data-easein="Power1.easeInOut" data-easeout="Power1.easeInOut" data-masterspeed="500"  data-rotate="0"  data-saveperformance="off"  data-title="Fifth" data-param1="" data-param2="" data-param3="" data-param4="" data-param5="" data-param6="" data-param7="" data-param8="" data-param9="" data-param10="" data-description="">
					        <!-- MAIN IMAGE -->
					        <img src="<?php echo e(asset('slider-revolution/assets/images/transparent.png')); ?>"  alt="" class="rev-slidebg" style="background-color: black;">
					        <!-- LAYERS -->

					        <!-- LAYER NR. 33 -->
					        <div class="tp-caption tp-shape tp-shapewrapper " 
					             id="slide-3067-layer-4" 
					             data-x="['center','center','center','center']" data-hoffset="['0','0','0','0']" 
					             data-y="['middle','middle','middle','middle']" data-voffset="['0','0','0','0']" 
					                        data-width="full"
					            data-height="full"
					            data-whitespace="nowrap"
					 
					            data-type="shape" 
					            data-basealign="slide" 
					            data-responsive_offset="off" 
					            data-responsive="off"
					            data-frames='[{"from":"opacity:0;","speed":500,"to":"o:1;","delay":500,"ease":"Power1.easeInOut"},{"delay":"wait","speed":1000,"to":"opacity:0;","ease":"nothing"}]'
					            data-textAlign="['left','left','left','left']"
					            data-paddingtop="[0,0,0,0]"
					            data-paddingright="[0,0,0,0]"
					            data-paddingbottom="[0,0,0,0]"
					            data-paddingleft="[0,0,0,0]"

					            style="z-index: 37;text-transform:left;background-color:rgba(0, 0, 0, 0.25);border-color:rgba(0, 0, 0, 0.50);border-width:0px;"> </div>

					        <!-- LAYER NR. 34 -->
					        <div class="tp-caption Team-Name tp-resizeme raleway_regular text-uppercase" 
					             id="slide-3067-layer-1" 
					             data-x="['center']" data-hoffset="['0']" 
					             data-y="['top','top','top','top']" data-voffset="['140','250','220','200']" 
					                        data-fontsize="['30','30','25','20']"
					            data-lineheight="['70','70','50','50']"
					            data-width="none"
					            data-height="none"
					            data-whitespace="nowrap"
					 
					            data-type="text" 
					            data-responsive_offset="on" 

					            data-frames='[{"from":"x:-50px;opacity:0;","speed":500,"to":"o:1;","delay":0,"ease":"Power1.easeInOut"},{"delay":"wait","speed":500,"to":"x:50px;opacity:0;","ease":"Power1.easeInOut"}]'
					            data-textAlign="['left','left','left','left']"
					            data-paddingtop="[0,0,0,0]"
					            data-paddingright="[0,0,0,0]"
					            data-paddingbottom="[0,0,0,0]"
					            data-paddingleft="[0,0,0,0]"

					            style="z-index: 38; white-space: nowrap;text-transform:left;">SISTEMA <span style="font-size: 2em;">Nanotex</span></div>


					        <!-- LAYER NR. 36 -->
					        <div class="tp-caption Team-Description tp-resizeme raleway_regular" 
					             id="slide-3067-layer-3" 
					             data-x="['center']" data-hoffset="['0']" 
					             data-y="['top','top','top','top']" data-voffset="['210','400','320','300']" 
					                        data-fontsize="['18','18','15','15']"
					            data-lineheight="['28','28','25','25']"
					            data-width="['640','640','640','360']"
					            data-height="none"
					            data-whitespace="normal"
					 
					            data-type="text" 
					            data-responsive_offset="on" 

					            data-frames='[{"from":"x:-50px;opacity:0;","speed":500,"to":"o:1;rZ:360;","delay":500,"ease":"Power1.easeInOut"},{"delay":"wait","speed":500,"to":"x:50px;opacity:0;","ease":"Power1.easeInOut"}]'
					            data-textAlign="['left','left','left','left']"
					            data-paddingtop="[0,0,0,0]"
					            data-paddingright="[0,0,0,0]"
					            data-paddingbottom="[0,0,0,0]"
					            data-paddingleft="[0,0,0,0]"

					            style="z-index: 40; min-width: 640px; max-width: 640px; white-space: normal;text-transform:left;">Sistema que utiliza la tecnología e ingeniería de materiales para generar un efecto de resistencia hidrófobo y generar colchones con material impermeable.<br>
					            Este tipo de colchón evitará que diferentes tipos de líquidos retrasen la penetración de la superficie.<br>
					            Un factor extra, es que el sudor será absorbido por las sábanas y no por el colchón, aumentado la limpieza del mismo.

					            </div>

					    </li>
					    <!-- SLIDE  -->
					    <li data-index="rs-3068" data-transition="fade" data-slotamount="default" data-hideafterloop="0" data-hideslideonmobile="off"  data-easein="Power1.easeInOut" data-easeout="Power1.easeInOut" data-masterspeed="500"  data-rotate="0"  data-saveperformance="off"  data-title="Sixth" data-param1="" data-param2="" data-param3="" data-param4="" data-param5="" data-param6="" data-param7="" data-param8="" data-param9="" data-param10="" data-description="">
					        <!-- MAIN IMAGE -->
					        <img src="<?php echo e(asset('slider-revolution/assets/images/transparent.png')); ?>"  alt="" class="rev-slidebg" style="background-color: black;">
					        <!-- LAYERS -->

					        <!-- LAYER NR. 41 -->
					        <div class="tp-caption tp-shape tp-shapewrapper " 
					             id="slide-3068-layer-4" 
					             data-x="['center','center','center','center']" data-hoffset="['0','0','0','0']" 
					             data-y="['middle','middle','middle','middle']" data-voffset="['0','0','0','0']" 
					                        data-width="full"
					            data-height="full"
					            data-whitespace="nowrap"
					 
					            data-type="shape" 
					            data-basealign="slide" 
					            data-responsive_offset="off" 
					            data-responsive="off"
					            data-frames='[{"from":"opacity:0;","speed":500,"to":"o:1;","delay":500,"ease":"Power1.easeInOut"},{"delay":"wait","speed":1000,"to":"opacity:0;","ease":"Power1.easeInOut"}]'
					            data-textAlign="['left','left','left','left']"
					            data-paddingtop="[0,0,0,0]"
					            data-paddingright="[0,0,0,0]"
					            data-paddingbottom="[0,0,0,0]"
					            data-paddingleft="[0,0,0,0]"

					            style="z-index: 45;text-transform:left;background-color:rgba(0, 0, 0, 0.25);border-color:rgba(0, 0, 0, 0.50);border-width:0px;"> </div>

					        <!-- LAYER NR. 42 -->
					        <div class="tp-caption Team-Name tp-resizeme raleway_medium" 
					             id="slide-3068-layer-1" 
					             data-x="['center']" data-hoffset="['0']" 
					             data-y="['top','top','top','top']" data-voffset="['140','250','220','200']" 
					                        data-fontsize="['30','30','25','20']"
					            data-lineheight="['70','70','50','50']"
					            data-width="none"
					            data-height="none"
					            data-whitespace="nowrap"
					 
					            data-type="text" 
					            data-responsive_offset="on" 

					            data-frames='[{"from":"x:-50px;opacity:0;","speed":500,"to":"o:1;","delay":0,"ease":"Power1.easeInOut"},{"delay":"wait","speed":500,"to":"x:50px;opacity:0;","ease":"Power1.easeInOut"}]'
					            data-textAlign="['left','left','left','left']"
					            data-paddingtop="[0,0,0,0]"
					            data-paddingright="[0,0,0,0]"
					            data-paddingbottom="[0,0,0,0]"
					            data-paddingleft="[0,0,0,0]"

					            style="z-index: 46; white-space: nowrap;text-transform:left;">SISTEMA <span style="font-size: 2em;">Smart Fit</span></div>


					        <!-- LAYER NR. 44 -->
					        <div class="tp-caption Team-Description tp-resizeme raleway_medium" 
					             id="slide-3068-layer-3" 
					             data-x="['center']" data-hoffset="['0']" 
					             data-y="['top','top','top','top']" data-voffset="['210','400','320','300']" 
					                        data-fontsize="['18','18','15','15']"
					            data-lineheight="['28','28','25','25']"
					            data-width="['640','640','640','360']"
					            data-height="none"
					            data-whitespace="normal"
					 
					            data-type="text" 
					            data-responsive_offset="on" 

					            data-frames='[{"from":"x:-50px;opacity:0;","speed":500,"to":"o:1;rZ:360;","delay":500,"ease":"Power1.easeInOut"},{"delay":"wait","speed":500,"to":"x:50px;opacity:0;","ease":"Power1.easeInOut"}]'
					            data-textAlign="['left','left','left','left']"
					            data-paddingtop="[0,0,0,0]"
					            data-paddingright="[0,0,0,0]"
					            data-paddingbottom="[0,0,0,0]"
					            data-paddingleft="[0,0,0,0]"

					            style="z-index: 48; min-width: 640px; max-width: 640px; white-space: normal;text-transform:left;">Sistema Inteligente (Memory Foam), este material consigue que el cuerpo, al estar acostado, no tenga puntos en los que la presión sea muy alta (cabeza, hombros, cadera), sino que el material se amolde a todo el cuerpo y disipe la presión de manera uniforme.
					            </div>

					    </li>
					    <!-- SLIDE  -->
					    <li data-index="rs-3069" data-transition="fade" data-slotamount="default" data-hideafterloop="0" data-hideslideonmobile="off"  data-easein="Power1.easeInOut" data-easeout="Power1.easeInOut" data-masterspeed="500"  data-rotate="0"  data-saveperformance="off"  data-title="Seventh" data-param1="" data-param2="" data-param3="" data-param4="" data-param5="" data-param6="" data-param7="" data-param8="" data-param9="" data-param10="" data-description="">
					        <!-- MAIN IMAGE -->
					        <img src="<?php echo e(asset('slider-revolution/assets/images/transparent.png')); ?>"  alt="" class="rev-slidebg" style="background-color: black;">
					        <!-- LAYERS -->

					        <!-- LAYER NR. 49 -->
					        <div class="tp-caption tp-shape tp-shapewrapper " 
					             id="slide-3069-layer-4" 
					             data-x="['center','center','center','center']" data-hoffset="['0','0','0','0']" 
					             data-y="['middle','middle','middle','middle']" data-voffset="['0','0','0','0']" 
					                        data-width="full"
					            data-height="full"
					            data-whitespace="nowrap"
					 
					            data-type="shape" 
					            data-basealign="slide" 
					            data-responsive_offset="off" 
					            data-responsive="off"
					            data-frames='[{"from":"opacity:0;","speed":500,"to":"o:1;","delay":500,"ease":"Power1.easeInOut"},{"delay":"wait","speed":1000,"to":"opacity:0;","ease":"Power1.easeInOut"}]'
					            data-textAlign="['left','left','left','left']"
					            data-paddingtop="[0,0,0,0]"
					            data-paddingright="[0,0,0,0]"
					            data-paddingbottom="[0,0,0,0]"
					            data-paddingleft="[0,0,0,0]"

					            style="z-index: 53;text-transform:left;background-color:rgba(0, 0, 0, 0.25);border-color:rgba(0, 0, 0, 0.50);border-width:0px;"> </div>

					        <!-- LAYER NR. 50 -->
					        <div class="tp-caption Team-Name tp-resizeme raleway_regular text-uppercase" 
					             id="slide-3069-layer-1" 
					             data-x="['center']" data-hoffset="['0']" 
					             data-y="['top','top','top','top']" data-voffset="['140','250','220','200']" 
					                        data-fontsize="['30','30','25','20']"
					            data-lineheight="['70','70','50','50']"
					            data-width="none"
					            data-height="none"
					            data-whitespace="nowrap"
					 
					            data-type="text" 
					            data-responsive_offset="on" 

					            data-frames='[{"from":"x:-50px;opacity:0;","speed":500,"to":"o:1;","delay":0,"ease":"Power1.easeInOut"},{"delay":"wait","speed":500,"to":"x:50px;opacity:0;","ease":"Power1.easeInOut"}]'
					            data-textAlign="['left','left','left','left']"
					            data-paddingtop="[0,0,0,0]"
					            data-paddingright="[0,0,0,0]"
					            data-paddingbottom="[0,0,0,0]"
					            data-paddingleft="[0,0,0,0]"

					            style="z-index: 54; white-space: nowrap;text-transform:left;">SISTEMA <span style="font-size: 2em;">Soft Dreams</span></div>


					        <!-- LAYER NR. 52 -->
					        <div class="tp-caption Team-Description tp-resizeme raleway_regular" 
					             id="slide-3069-layer-3" 
					             data-x="['center']" data-hoffset="['0']" 
					             data-y="['top','top','top','top']" data-voffset="['210','400','320','300']" 
					                        data-fontsize="['18','18','15','15']"
					            data-lineheight="['28','28','25','25']"
					            data-width="['640','640','640','360']"
					            data-height="none"
					            data-whitespace="normal"
					 
					            data-type="text" 
					            data-responsive_offset="on" 

					            data-frames='[{"from":"x:-50px;opacity:0;","speed":500,"to":"o:1;rZ:360;","delay":500,"ease":"Power1.easeInOut"},{"delay":"wait","speed":500,"to":"x:50px;opacity:0;","ease":"Power1.easeInOut"}]'
					            data-textAlign="['left','left','left','left']"
					            data-paddingtop="[0,0,0,0]"
					            data-paddingright="[0,0,0,0]"
					            data-paddingbottom="[0,0,0,0]"
					            data-paddingleft="[0,0,0,0]"

					            style="z-index: 56; min-width: 640px; max-width: 640px; white-space: normal;text-transform:left;">
					            	<ul class="list-unstyled">
					            		<li>Fibras de poliuretano de alta recuperación.</li>
					            		<li>Posee mayor acojinamiento multicelular.</li>
					            		<li>Brinda mayor firmeza y comodidad.</li>
					            	</ul>
					            </div>
					    </li>
					    <!-- SLIDE  -->
					    <li data-index="rs-3070" data-transition="fade" data-slotamount="default" data-hideafterloop="0" data-hideslideonmobile="off"  data-easein="Power1.easeInOut" data-easeout="Power1.easeInOut" data-masterspeed="500"  data-rotate="0"  data-saveperformance="off"  data-title="Seventh" data-param1="" data-param2="" data-param3="" data-param4="" data-param5="" data-param6="" data-param7="" data-param8="" data-param9="" data-param10="" data-description="">
					        <!-- MAIN IMAGE -->
					        <img src="<?php echo e(asset('slider-revolution/assets/images/transparent.png')); ?>"  alt="" class="rev-slidebg" style="background-color: black;">
					        <!-- LAYERS -->

					        <!-- LAYER NR. 49 -->
					        <div class="tp-caption tp-shape tp-shapewrapper " 
					             id="slide-3070-layer-4" 
					             data-x="['center','center','center','center']" data-hoffset="['0','0','0','0']" 
					             data-y="['middle','middle','middle','middle']" data-voffset="['0','0','0','0']" 
					                        data-width="full"
					            data-height="full"
					            data-whitespace="nowrap"
					 
					            data-type="shape" 
					            data-basealign="slide" 
					            data-responsive_offset="off" 
					            data-responsive="off"
					            data-frames='[{"from":"opacity:0;","speed":500,"to":"o:1;","delay":500,"ease":"Power1.easeInOut"},{"delay":"wait","speed":1000,"to":"opacity:0;","ease":"Power1.easeInOut"}]'
					            data-textAlign="['left','left','left','left']"
					            data-paddingtop="[0,0,0,0]"
					            data-paddingright="[0,0,0,0]"
					            data-paddingbottom="[0,0,0,0]"
					            data-paddingleft="[0,0,0,0]"

					            style="z-index: 57;text-transform:left;background-color:rgba(0, 0, 0, 0.25);border-color:rgba(0, 0, 0, 0.50);border-width:0px;"> </div>

					        <!-- LAYER NR. 50 -->
					        <div class="tp-caption Team-Name tp-resizeme raleway_regular text-uppercase" 
					             id="slide-3070-layer-1" 
					             data-x="['center']" data-hoffset="['0']" 
					             data-y="['top','top','top','top']" data-voffset="['140','250','220','200']" 
					                        data-fontsize="['30','30','25','20']"
					            data-lineheight="['70','70','50','50']"
					            data-width="none"
					            data-height="none"
					            data-whitespace="nowrap"
					 
					            data-type="text" 
					            data-responsive_offset="on" 

					            data-frames='[{"from":"x:-50px;opacity:0;","speed":500,"to":"o:1;","delay":0,"ease":"Power1.easeInOut"},{"delay":"wait","speed":500,"to":"x:50px;opacity:0;","ease":"Power1.easeInOut"}]'
					            data-textAlign="['left','left','left','left']"
					            data-paddingtop="[0,0,0,0]"
					            data-paddingright="[0,0,0,0]"
					            data-paddingbottom="[0,0,0,0]"
					            data-paddingleft="[0,0,0,0]"

					            style="z-index: 58; white-space: nowrap;text-transform:left;">SISTEMA <span style="font-size: 2em;">Superior Foam</span></div>


					        <!-- LAYER NR. 52 -->
					        <div class="tp-caption Team-Description tp-resizeme raleway_regular" 
					             id="slide-3070-layer-3" 
					             data-x="['center']" data-hoffset="['0']" 
					             data-y="['top','top','top','top']" data-voffset="['210','400','320','300']" 
					                        data-fontsize="['18','18','15','15']"
					            data-lineheight="['28','28','25','25']"
					            data-width="['640','640','640','360']"
					            data-height="none"
					            data-whitespace="normal"
					 
					            data-type="text" 
					            data-responsive_offset="on" 

					            data-frames='[{"from":"x:-50px;opacity:0;","speed":500,"to":"o:1;rZ:360;","delay":500,"ease":"Power1.easeInOut"},{"delay":"wait","speed":500,"to":"x:50px;opacity:0;","ease":"Power1.easeInOut"}]'
					            data-textAlign="['left','left','left','left']"
					            data-paddingtop="[0,0,0,0]"
					            data-paddingright="[0,0,0,0]"
					            data-paddingbottom="[0,0,0,0]"
					            data-paddingleft="[0,0,0,0]"

					            style="z-index: 59; min-width: 640px; max-width: 640px; white-space: normal;text-transform:left;">
					            	<ul class="list-unstyled">
					            		<li>Espumas de alta suavidad que brinda una mayor comfort en la columna vertebral.</li>
					            		<li>Fibras de poliuretano en diferentes densidades que permiten una recuperación y durabilidad en el colchón</li>
					            	</ul>
					            </div>
					    </li>
					    <!-- SLIDE  -->
					    <li data-index="rs-3071" data-transition="fade" data-slotamount="default" data-hideafterloop="0" data-hideslideonmobile="off"  data-easein="Power1.easeInOut" data-easeout="Power1.easeInOut" data-masterspeed="500"  data-rotate="0"  data-saveperformance="off"  data-title="Seventh" data-param1="" data-param2="" data-param3="" data-param4="" data-param5="" data-param6="" data-param7="" data-param8="" data-param9="" data-param10="" data-description="">
					        <!-- MAIN IMAGE -->
					        <img src="<?php echo e(asset('slider-revolution/assets/images/transparent.png')); ?>"  alt="" class="rev-slidebg" style="background-color: black;">
					        <!-- LAYERS -->

					        <!-- LAYER NR. 49 -->
					        <div class="tp-caption tp-shape tp-shapewrapper " 
					             id="slide-3071-layer-4" 
					             data-x="['center','center','center','center']" data-hoffset="['0','0','0','0']" 
					             data-y="['middle','middle','middle','middle']" data-voffset="['0','0','0','0']" 
					                        data-width="full"
					            data-height="full"
					            data-whitespace="nowrap"
					 
					            data-type="shape" 
					            data-basealign="slide" 
					            data-responsive_offset="off" 
					            data-responsive="off"
					            data-frames='[{"from":"opacity:0;","speed":500,"to":"o:1;","delay":500,"ease":"Power1.easeInOut"},{"delay":"wait","speed":1000,"to":"opacity:0;","ease":"Power1.easeInOut"}]'
					            data-textAlign="['left','left','left','left']"
					            data-paddingtop="[0,0,0,0]"
					            data-paddingright="[0,0,0,0]"
					            data-paddingbottom="[0,0,0,0]"
					            data-paddingleft="[0,0,0,0]"

					            style="z-index: 60;text-transform:left;background-color:rgba(0, 0, 0, 0.25);border-color:rgba(0, 0, 0, 0.50);border-width:0px;"> </div>

					        <!-- LAYER NR. 50 -->
					        <div class="tp-caption Team-Name tp-resizeme raleway_regular text-uppercase" 
					             id="slide-3071-layer-1" 
					             data-x="['center']" data-hoffset="['0']" 
					             data-y="['top','top','top','top']" data-voffset="['140','250','220','200']" 
					                        data-fontsize="['30','30','25','20']"
					            data-lineheight="['70','70','50','50']"
					            data-width="none"
					            data-height="none"
					            data-whitespace="nowrap"
					 
					            data-type="text" 
					            data-responsive_offset="on" 

					            data-frames='[{"from":"x:-50px;opacity:0;","speed":500,"to":"o:1;","delay":0,"ease":"Power1.easeInOut"},{"delay":"wait","speed":500,"to":"x:50px;opacity:0;","ease":"Power1.easeInOut"}]'
					            data-textAlign="['left','left','left','left']"
					            data-paddingtop="[0,0,0,0]"
					            data-paddingright="[0,0,0,0]"
					            data-paddingbottom="[0,0,0,0]"
					            data-paddingleft="[0,0,0,0]"

					            style="z-index: 61; white-space: nowrap;text-transform:left;">SISTEMA <span style="font-size: 2em;">Twist</span></div>


					        <!-- LAYER NR. 52 -->
					        <div class="tp-caption Team-Description tp-resizeme raleway_regular" 
					             id="slide-3071-layer-3" 
					             data-x="['center']" data-hoffset="['0']" 
					             data-y="['top','top','top','top']" data-voffset="['210','400','320','300']" 
					                        data-fontsize="['18','18','15','15']"
					            data-lineheight="['28','28','25','25']"
					            data-width="['640','640','640','360']"
					            data-height="none"
					            data-whitespace="normal"
					 
					            data-type="text" 
					            data-responsive_offset="on" 

					            data-frames='[{"from":"x:-50px;opacity:0;","speed":500,"to":"o:1;rZ:360;","delay":500,"ease":"Power1.easeInOut"},{"delay":"wait","speed":500,"to":"x:50px;opacity:0;","ease":"Power1.easeInOut"}]'
					            data-textAlign="['left','left','left','left']"
					            data-paddingtop="[0,0,0,0]"
					            data-paddingright="[0,0,0,0]"
					            data-paddingbottom="[0,0,0,0]"
					            data-paddingleft="[0,0,0,0]"

					            style="z-index: 62; min-width: 640px; max-width: 640px; white-space: normal;text-transform:left;">
					            	<ul class="list-unstyled">
					            		<li>Materiales y acojinamientos de alta calidad y durabilidad, repartidos en ambos lados.</li>
					            		<li>Colchón de vuelta y rotación.</li>
					            	</ul>
					            </div>
					    </li>
					    <!-- SLIDE  -->
					    <li data-index="rs-3072" data-transition="fade" data-slotamount="default" data-hideafterloop="0" data-hideslideonmobile="off"  data-easein="Power1.easeInOut" data-easeout="Power1.easeInOut" data-masterspeed="500"  data-rotate="0"  data-saveperformance="off"  data-title="Seventh" data-param1="" data-param2="" data-param3="" data-param4="" data-param5="" data-param6="" data-param7="" data-param8="" data-param9="" data-param10="" data-description="">
					        <!-- MAIN IMAGE -->
					        <img src="<?php echo e(asset('slider-revolution/assets/images/transparent.png')); ?>"  alt="" class="rev-slidebg" style="background-color: black;">
					        <!-- LAYERS -->

					        <!-- LAYER NR. 49 -->
					        <div class="tp-caption tp-shape tp-shapewrapper " 
					             id="slide-3072-layer-4" 
					             data-x="['center','center','center','center']" data-hoffset="['0','0','0','0']" 
					             data-y="['middle','middle','middle','middle']" data-voffset="['0','0','0','0']" 
					                        data-width="full"
					            data-height="full"
					            data-whitespace="nowrap"
					 
					            data-type="shape" 
					            data-basealign="slide" 
					            data-responsive_offset="off" 
					            data-responsive="off"
					            data-frames='[{"from":"opacity:0;","speed":500,"to":"o:1;","delay":500,"ease":"Power1.easeInOut"},{"delay":"wait","speed":1000,"to":"opacity:0;","ease":"Power1.easeInOut"}]'
					            data-textAlign="['left','left','left','left']"
					            data-paddingtop="[0,0,0,0]"
					            data-paddingright="[0,0,0,0]"
					            data-paddingbottom="[0,0,0,0]"
					            data-paddingleft="[0,0,0,0]"

					            style="z-index: 60;text-transform:left;background-color:rgba(0, 0, 0, 0.25);border-color:rgba(0, 0, 0, 0.50);border-width:0px;"> </div>

					        <!-- LAYER NR. 50 -->
					        <div class="tp-caption Team-Name tp-resizeme raleway_regular text-uppercase" 
					             id="slide-3072-layer-1" 
					             data-x="['center']" data-hoffset="['0']" 
					             data-y="['top','top','top','top']" data-voffset="['140','250','220','200']" 
					                        data-fontsize="['30','30','25','20']"
					            data-lineheight="['70','70','50','50']"
					            data-width="none"
					            data-height="none"
					            data-whitespace="nowrap"
					 
					            data-type="text" 
					            data-responsive_offset="on" 

					            data-frames='[{"from":"x:-50px;opacity:0;","speed":500,"to":"o:1;","delay":0,"ease":"Power1.easeInOut"},{"delay":"wait","speed":500,"to":"x:50px;opacity:0;","ease":"Power1.easeInOut"}]'
					            data-textAlign="['left','left','left','left']"
					            data-paddingtop="[0,0,0,0]"
					            data-paddingright="[0,0,0,0]"
					            data-paddingbottom="[0,0,0,0]"
					            data-paddingleft="[0,0,0,0]"

					            style="z-index: 61; white-space: nowrap;text-transform:left;">SISTEMA <span style="font-size: 2em;">Up Turn</span></div>


					        <!-- LAYER NR. 52 -->
					        <div class="tp-caption Team-Description tp-resizeme raleway_regular" 
					             id="slide-3072-layer-3" 
					             data-x="['center']" data-hoffset="['0']" 
					             data-y="['top','top','top','top']" data-voffset="['210','400','320','300']" 
					                        data-fontsize="['18','18','15','15']"
					            data-lineheight="['28','28','25','25']"
					            data-width="['640','640','640','360']"
					            data-height="none"
					            data-whitespace="normal"
					 
					            data-type="text" 
					            data-responsive_offset="on" 

					            data-frames='[{"from":"x:-50px;opacity:0;","speed":500,"to":"o:1;rZ:360;","delay":500,"ease":"Power1.easeInOut"},{"delay":"wait","speed":500,"to":"x:50px;opacity:0;","ease":"Power1.easeInOut"}]'
					            data-textAlign="['left','left','left','left']"
					            data-paddingtop="[0,0,0,0]"
					            data-paddingright="[0,0,0,0]"
					            data-paddingbottom="[0,0,0,0]"
					            data-paddingleft="[0,0,0,0]"

					            style="z-index: 62; min-width: 640px; max-width: 640px; white-space: normal;text-transform:left;">
					            	<ul class="list-unstyled">
					            		<li>Materiales y acojinamientos de alta calidad y durabilidad, concentrados en una sola cara.</li>
					            		<li>Sin necesidad de darle vuelta.</li>
					            	</ul>
					            </div>
					    </li>
					    <!-- SLIDE  -->
					    <li data-index="rs-3073" data-transition="fade" data-slotamount="default" data-hideafterloop="0" data-hideslideonmobile="off"  data-easein="Power1.easeInOut" data-easeout="Power1.easeInOut" data-masterspeed="500"  data-rotate="0"  data-saveperformance="off"  data-title="Seventh" data-param1="" data-param2="" data-param3="" data-param4="" data-param5="" data-param6="" data-param7="" data-param8="" data-param9="" data-param10="" data-description="">
					        <!-- MAIN IMAGE -->
					        <img src="<?php echo e(asset('slider-revolution/assets/images/transparent.png')); ?>"  alt="" class="rev-slidebg" style="background-color: black;">
					        <!-- LAYERS -->

					        <!-- LAYER NR. 49 -->
					        <div class="tp-caption tp-shape tp-shapewrapper " 
					             id="slide-3073-layer-4" 
					             data-x="['center','center','center','center']" data-hoffset="['0','0','0','0']" 
					             data-y="['middle','middle','middle','middle']" data-voffset="['0','0','0','0']" 
					                        data-width="full"
					            data-height="full"
					            data-whitespace="nowrap"
					 
					            data-type="shape" 
					            data-basealign="slide" 
					            data-responsive_offset="off" 
					            data-responsive="off"
					            data-frames='[{"from":"opacity:0;","speed":500,"to":"o:1;","delay":500,"ease":"Power1.easeInOut"},{"delay":"wait","speed":1000,"to":"opacity:0;","ease":"Power1.easeInOut"}]'
					            data-textAlign="['left','left','left','left']"
					            data-paddingtop="[0,0,0,0]"
					            data-paddingright="[0,0,0,0]"
					            data-paddingbottom="[0,0,0,0]"
					            data-paddingleft="[0,0,0,0]"

					            style="z-index: 60;text-transform:left;background-color:rgba(0, 0, 0, 0.25);border-color:rgba(0, 0, 0, 0.50);border-width:0px;"> </div>

					        <!-- LAYER NR. 50 -->
					        <div class="tp-caption Team-Name tp-resizeme raleway_regular text-uppercase" 
					             id="slide-3073-layer-1" 
					             data-x="['center']" data-hoffset="['0']" 
					             data-y="['top','top','top','top']" data-voffset="['140','250','220','200']" 
					                        data-fontsize="['30','30','25','20']"
					            data-lineheight="['70','70','50','50']"
					            data-width="none"
					            data-height="none"
					            data-whitespace="nowrap"
					 
					            data-type="text" 
					            data-responsive_offset="on" 

					            data-frames='[{"from":"x:-50px;opacity:0;","speed":500,"to":"o:1;","delay":0,"ease":"Power1.easeInOut"},{"delay":"wait","speed":500,"to":"x:50px;opacity:0;","ease":"Power1.easeInOut"}]'
					            data-textAlign="['left','left','left','left']"
					            data-paddingtop="[0,0,0,0]"
					            data-paddingright="[0,0,0,0]"
					            data-paddingbottom="[0,0,0,0]"
					            data-paddingleft="[0,0,0,0]"

					            style="z-index: 61; white-space: nowrap;text-transform:left;">SISTEMA <span style="font-size: 2em;">Free VEnt</span></div>


					        <!-- LAYER NR. 52 -->
					        <div class="tp-caption Team-Description tp-resizeme raleway_regular" 
					             id="slide-3073-layer-3" 
					             data-x="['center']" data-hoffset="['0']" 
					             data-y="['top','top','top','top']" data-voffset="['210','400','320','300']" 
					                        data-fontsize="['18','18','15','15']"
					            data-lineheight="['28','28','25','25']"
					            data-width="['640','640','640','360']"
					            data-height="none"
					            data-whitespace="normal"
					 
					            data-type="text" 
					            data-responsive_offset="on" 

					            data-frames='[{"from":"x:-50px;opacity:0;","speed":500,"to":"o:1;rZ:360;","delay":500,"ease":"Power1.easeInOut"},{"delay":"wait","speed":500,"to":"x:50px;opacity:0;","ease":"Power1.easeInOut"}]'
					            data-textAlign="['left','left','left','left']"
					            data-paddingtop="[0,0,0,0]"
					            data-paddingright="[0,0,0,0]"
					            data-paddingbottom="[0,0,0,0]"
					            data-paddingleft="[0,0,0,0]"

					            style="z-index: 62; min-width: 640px; max-width: 640px; white-space: normal;text-transform:left;">Sistema que genera un intercambio de aire, del interior al exterior del colchón, evaporando la humedad acumulada durante las horas de descanso.
					            </div>

					    </li>
					    <!-- SLIDE  -->
					    <li data-index="rs-3074" data-transition="fade" data-slotamount="default" data-hideafterloop="0" data-hideslideonmobile="off"  data-easein="Power1.easeInOut" data-easeout="Power1.easeInOut" data-masterspeed="500"  data-rotate="0"  data-saveperformance="off"  data-title="Seventh" data-param1="" data-param2="" data-param3="" data-param4="" data-param5="" data-param6="" data-param7="" data-param8="" data-param9="" data-param10="" data-description="">
					        <!-- MAIN IMAGE -->
					        <img src="<?php echo e(asset('slider-revolution/assets/images/transparent.png')); ?>"  alt="" class="rev-slidebg" style="background-color: black;">
					        <!-- LAYERS -->

					        <!-- LAYER NR. 49 -->
					        <div class="tp-caption tp-shape tp-shapewrapper " 
					             id="slide-3074-layer-4" 
					             data-x="['center','center','center','center']" data-hoffset="['0','0','0','0']" 
					             data-y="['middle','middle','middle','middle']" data-voffset="['0','0','0','0']" 
					                        data-width="full"
					            data-height="full"
					            data-whitespace="nowrap"
					 
					            data-type="shape" 
					            data-basealign="slide" 
					            data-responsive_offset="off" 
					            data-responsive="off"
					            data-frames='[{"from":"opacity:0;","speed":500,"to":"o:1;","delay":500,"ease":"Power1.easeInOut"},{"delay":"wait","speed":1000,"to":"opacity:0;","ease":"Power1.easeInOut"}]'
					            data-textAlign="['left','left','left','left']"
					            data-paddingtop="[0,0,0,0]"
					            data-paddingright="[0,0,0,0]"
					            data-paddingbottom="[0,0,0,0]"
					            data-paddingleft="[0,0,0,0]"

					            style="z-index: 60;text-transform:left;background-color:rgba(0, 0, 0, 0.25);border-color:rgba(0, 0, 0, 0.50);border-width:0px;"> </div>

					        <!-- LAYER NR. 50 -->
					        <div class="tp-caption Team-Name tp-resizeme raleway_regular text-uppercase" 
					             id="slide-3074-layer-1" 
					             data-x="['center']" data-hoffset="['0']" 
					             data-y="['top','top','top','top']" data-voffset="['140','250','220','200']" 
					                        data-fontsize="['30','30','25','20']"
					            data-lineheight="['70','70','50','50']"
					            data-width="none"
					            data-height="none"
					            data-whitespace="nowrap"
					 
					            data-type="text" 
					            data-responsive_offset="on" 

					            data-frames='[{"from":"x:-50px;opacity:0;","speed":500,"to":"o:1;","delay":0,"ease":"Power1.easeInOut"},{"delay":"wait","speed":500,"to":"x:50px;opacity:0;","ease":"Power1.easeInOut"}]'
					            data-textAlign="['left','left','left','left']"
					            data-paddingtop="[0,0,0,0]"
					            data-paddingright="[0,0,0,0]"
					            data-paddingbottom="[0,0,0,0]"
					            data-paddingleft="[0,0,0,0]"

					            style="z-index: 61; white-space: nowrap;text-transform:left;">SISTEMA <span style="font-size: 2em;">Rest Gel</span></div>


					        <!-- LAYER NR. 52 -->
					        <div class="tp-caption Team-Description tp-resizeme raleway_regular" 
					             id="slide-3074-layer-3" 
					             data-x="['center']" data-hoffset="['0']" 
					             data-y="['top','top','top','top']" data-voffset="['210','400','320','300']" 
					                        data-fontsize="['18','18','15','15']"
					            data-lineheight="['28','28','25','25']"
					            data-width="['640','640','640','360']"
					            data-height="none"
					            data-whitespace="normal"
					 
					            data-type="text" 
					            data-responsive_offset="on" 

					            data-frames='[{"from":"x:-50px;opacity:0;","speed":500,"to":"o:1;rZ:360;","delay":500,"ease":"Power1.easeInOut"},{"delay":"wait","speed":500,"to":"x:50px;opacity:0;","ease":"Power1.easeInOut"}]'
					            data-textAlign="['left','left','left','left']"
					            data-paddingtop="[0,0,0,0]"
					            data-paddingright="[0,0,0,0]"
					            data-paddingbottom="[0,0,0,0]"
					            data-paddingleft="[0,0,0,0]"

					            style="z-index: 62; min-width: 640px; max-width: 640px; white-space: normal;text-transform:left;">
					            <ul class="list-unstyled">
					            	<li>Mismas propiedades que el Memory Foam, enriquecidas con el gel (mayor viscosidad), que nos ayuda a bajar la temperatura del colchón gracias al poder del mismo.</li>
					            	<li>Se utiliza en la fabricación en colchones de alta gama.</li>
					            </ul>
					            </div>

					    </li>
					</ul>
					<div style="" class="tp-static-layers">

				        <!-- LAYER NR. 57 
				        <div class="tp-caption tp-shape tp-shapewrapper  tp-resizeme tp-static-layer" 
				            id="slider-1082-layer-1" 
				            data-x="['center','center','center','center']" data-hoffset="['0','0','0','0']" 
				            data-y="['top','top','top','top']" data-voffset="['0','0','0','0']" 
	                       	data-width="full"
				            data-height="['100','100','100','50']"
				            data-whitespace="nowrap"
				 
				            data-type="shape" 
				            data-responsive_offset="on" 

				            data-startslide="0" 
				            data-endslide="11" 
				            data-frames='[{"from":"y:top;","speed":500,"to":"o:1;","delay":0,"ease":"Power2.easeInOut"},{"delay":8300,"speed":500,"to":"opacity:0;","ease":"nothing"}]'
				            data-textAlign="['left','left','left','left']"
				            data-paddingtop="[0,0,0,0]"
				            data-paddingright="[0,0,0,0]"
				            data-paddingbottom="[0,0,0,0]"
				            data-paddingleft="[0,0,0,0]"

				            style="z-index: 71;text-transform:left;background-color:rgba(255, 255, 255, 1.00);border-color:rgba(0, 0, 0, 0);border-width:0px;"> </div>-->

				        <!-- LAYER NR. 58 -->
				        <div class="tp-caption Team-Thumb tp-resizeme tp-static-layer" 
				            id="slider-1082-layer-2" 
				            data-x="['center','center','center','center']" data-hoffset="['-550','-440','-330','-200']" 
				            data-y="['top','top','top','top']" data-voffset="['0','50','50','0']" 
				            data-width="none"
				            data-height="none"
				            data-whitespace="nowrap"
				 
				            data-type="image" 
				            data-actions='[{"event":"mouseenter","action":"jumptoslide","slide":"rs-3063","delay":""}]'
				            data-responsive_offset="on" 

				            data-startslide="0" 
				            data-endslide="11" 
				            data-frames='[
				            	{"from":"opacity:0;","speed":300,"to":"o:1;sX:0.5;sY:0.5;","delay":500,"ease":"Power2.easeInOut"},{"delay":"wait","speed":300,"to":"opacity:0;","ease":"nothing"},{"frame":"hover","speed":"500","ease":"Power2.easeInOut","to":"o:1;sX:0.7;sY:0.7;skX:0px;skY:0px;rX:0;rY:0;rZ:0;z:0;","style":"c:rgba(255, 255, 255, 1.00);br:0 0 0px 0;"}]'
				            data-textAlign="['left','left','left','left']"
				            data-paddingtop="[0,0,0,0]"
				            data-paddingright="[0,0,0,0]"
				            data-paddingbottom="[0,0,0,0]"
				            data-paddingleft="[0,0,0,0]"

				            style="z-index: 72; line-height: 22px;text-transform:left;cursor:pointer;"><img src="<?php echo e(asset('img/sistemas/comfort-tech-colchones-carreiro.png')); ?>" alt="" data-ww="['150px','100px','100px','100px']" data-hh="['auto']" data-no-retina> </div>

				        <!-- LAYER NR. 59 -->
				        <div class="tp-caption   tp-resizeme tp-static-layer" 
				            id="slider-1082-layer-3" 
				            data-x="['center','center','center','center']" data-hoffset="['-450','-360','-270','-120']" 
				            data-y="['top','top','top','top']" data-voffset="['0','50','50','0']" 
				            data-width="none"
				            data-height="none"
				            data-whitespace="nowrap"
				 
				            data-type="image" 
				            data-actions='[{"event":"mouseenter","action":"jumptoslide","slide":"rs-3064","delay":""}]'
				            data-responsive_offset="on" 

				            data-startslide="0" 
				            data-endslide="11" 
				            data-frames='[{"from":"opacity:0;","speed":300,"to":"o:1;sX:0.5;sY:0.5;","delay":500,"ease":"Power2.easeInOut"},{"delay":"wait","speed":300,"to":"opacity:0;","ease":"nothing"},{"frame":"hover","speed":"500","ease":"Power2.easeInOut","to":"o:1;sX:0.7;sY:0.7;rX:0;rY:0;rZ:0;z:0;","style":"c:rgba(0, 0, 0, 1.00);br:0px 0px 0px 0px;"}]'
				            data-textAlign="['left','left','left','left']"
				            data-paddingtop="[0,0,0,0]"
				            data-paddingright="[0,0,0,0]"
				            data-paddingbottom="[0,0,0,0]"
				            data-paddingleft="[0,0,0,0]"

				            style="z-index: 73;text-transform:left;border-width:0px;cursor:pointer;"><img src="<?php echo e(asset('img/sistemas/flame-proof-colchones-carreiro.png')); ?>" alt="" data-ww="['150px','100px','100px','100px']" data-hh="['auto']" data-no-retina> </div>

				        <!-- LAYER NR. 60 -->
				        <div class="tp-caption   tp-resizeme tp-static-layer" 
				            id="slider-1082-layer-4" 
				            data-x="['center','center','center','center']" data-hoffset="['-350','-280','-210','-40']" 
				            data-y="['top','top','top','top']" data-voffset="['0','50','50','0']" 
				            data-width="none"
				            data-height="none"
				            data-whitespace="nowrap"
				 
				            data-type="image" 
				            data-actions='[{"event":"mouseenter","action":"jumptoslide","slide":"rs-3065","delay":""}]'
				            data-responsive_offset="on" 

				            data-startslide="0" 
				            data-endslide="11" 
				            data-frames='[{"from":"opacity:0;","speed":300,"to":"o:1;sX:0.5;sY:0.5;","delay":500,"ease":"Power2.easeInOut"},{"delay":"wait","speed":300,"to":"opacity:0;","ease":"nothing"},{"frame":"hover","speed":"500","ease":"Power2.easeInOut","to":"o:1;sX:0.7;sY:0.7;rX:0;rY:0;rZ:0;z:0;","style":"c:rgba(255, 255, 255, 1.00);"}]'
				            data-textAlign="['left','left','left','left']"
				            data-paddingtop="[0,0,0,0]"
				            data-paddingright="[0,0,0,0]"
				            data-paddingbottom="[0,0,0,0]"
				            data-paddingleft="[0,0,0,0]"

				            style="z-index: 74;text-transform:left;border-width:0px;cursor:pointer;"><img src="<?php echo e(asset('img/sistemas/hight-resistance-colchones-carreiro.png')); ?>" alt="" data-ww="['150px','100px','100px','100px']" data-hh="['auto']" data-no-retina> </div>

				        <!-- LAYER NR. 61 -->
				        <div class="tp-caption   tp-resizeme tp-static-layer" 
				            id="slider-1082-layer-5" 
				            data-x="['center','center','center','center']" data-hoffset="['-250','-200','-150','40']" 
				            data-y="['top','top','top','top']" data-voffset="['0','50','50','0']" 
				            data-width="none"
				            data-height="none"
				            data-whitespace="nowrap"
				 
				            data-type="image" 
				            data-actions='[{"event":"mouseenter","action":"jumptoslide","slide":"rs-3066","delay":""}]'
				            data-responsive_offset="on" 

				            data-startslide="0" 
				            data-endslide="11" 
				            data-frames='[{"from":"opacity:0;","speed":300,"to":"o:1;sX:0.5;sY:0.5;","delay":500,"ease":"Power2.easeInOut"},{"delay":"wait","speed":300,"to":"opacity:0;","ease":"nothing"},{"frame":"hover","speed":"500","ease":"Power2.easeInOut","to":"o:1;sX:0.7;sY:0.7;rX:0;rY:0;rZ:0;z:0;","style":"c:rgba(255, 255, 255, 1.00);"}]'
				            data-textAlign="['left','left','left','left']"
				            data-paddingtop="[0,0,0,0]"
				            data-paddingright="[0,0,0,0]"
				            data-paddingbottom="[0,0,0,0]"
				            data-paddingleft="[0,0,0,0]"

				            style="z-index: 75;text-transform:left;border-width:0px;cursor:pointer;"><img src="<?php echo e(asset('img/sistemas/multizone-technology-colchones-carreiro.png')); ?>" alt="" data-ww="['150px','100px','100px','100px']" data-hh="['auto']" data-no-retina> </div>

				        <!-- LAYER NR. 62 -->
				        <div class="tp-caption   tp-resizeme tp-static-layer" 
				            id="slider-1082-layer-6" 
				            data-x="['center','center','center','center']" data-hoffset="['-150','-120','-90','120']" 
				            data-y="['top','top','top','top']" data-voffset="['0','50','50','0']" 
				            data-width="none"
				            data-height="none"
				            data-whitespace="nowrap"
				 
				            data-type="image" 
				            data-actions='[{"event":"mouseenter","action":"jumptoslide","slide":"rs-3067","delay":""}]'
				            data-responsive_offset="on" 

				            data-startslide="0" 
				            data-endslide="11" 
				            data-frames='[{"from":"opacity:0;","speed":300,"to":"o:1;sX:0.5;sY:0.5;","delay":500,"ease":"Power2.easeInOut"},{"delay":"wait","speed":300,"to":"opacity:0;","ease":"nothing"},{"frame":"hover","speed":"500","ease":"Power2.easeInOut","to":"o:1;sX:0.7;sY:0.7;rX:0;rY:0;rZ:0;z:0;","style":"c:rgba(255, 255, 255, 1.00);"}]'
				            data-textAlign="['left','left','left','left']"
				            data-paddingtop="[0,0,0,0]"
				            data-paddingright="[0,0,0,0]"
				            data-paddingbottom="[0,0,0,0]"
				            data-paddingleft="[0,0,0,0]"

				            style="z-index: 76;text-transform:left;border-width:0px;cursor:pointer;"><img src="<?php echo e(asset('img/sistemas/nanotex-colchones-carreiro.png')); ?>" alt="" data-ww="['150px','100px','100px','100px']" data-hh="['auto']" data-no-retina> </div>

			            <!-- LAYER NR. 62 COPIA -->
				        <div class="tp-caption   tp-resizeme tp-static-layer" 
				            id="slider-1082-layer-12" 
				            data-x="['center','center','center','center']" data-hoffset="['-50','-40','-30','200']" 
				            data-y="['top','top','top','top']" data-voffset="['0','50','50','0']" 
				            data-width="none"
				            data-height="none"
				            data-whitespace="nowrap"
				 
				            data-type="image" 
				            data-actions='[{"event":"mouseenter","action":"jumptoslide","slide":"rs-3074","delay":""}]'
				            data-responsive_offset="on" 

				            data-startslide="0" 
				            data-endslide="11" 
				            data-frames='[{"from":"opacity:0;","speed":300,"to":"o:1;sX:0.5;sY:0.5;","delay":500,"ease":"Power2.easeInOut"},{"delay":"wait","speed":300,"to":"opacity:0;","ease":"nothing"},{"frame":"hover","speed":"500","ease":"Power2.easeInOut","to":"o:1;sX:0.7;sY:0.7;rX:0;rY:0;rZ:0;z:0;","style":"c:rgba(255, 255, 255, 1.00);"}]'
				            data-textAlign="['left','left','left','left']"
				            data-paddingtop="[0,0,0,0]"
				            data-paddingright="[0,0,0,0]"
				            data-paddingbottom="[0,0,0,0]"
				            data-paddingleft="[0,0,0,0]"

				            style="z-index: 76;text-transform:left;border-width:0px;cursor:pointer;"><img src="<?php echo e(asset('img/sistemas/rest-gel-colchones-carreiro.png')); ?>" alt="" data-ww="['150px','100px','100px','100px']" data-hh="['auto']" data-no-retina> </div>

				        <!-- LAYER NR. 63 -->
				        <div class="tp-caption   tp-resizeme tp-static-layer" 
				            id="slider-1082-layer-7" 
				            data-x="['center','center','center','center']" data-hoffset="['50','40','30','-200']" 
				            data-y="['top','top','top','top']" data-voffset="['0','50','50','80']" 
				            data-width="none"
				            data-height="none"
				            data-whitespace="nowrap"
				 
				            data-type="image" 
				            data-actions='[{"event":"mouseenter","action":"jumptoslide","slide":"rs-3068","delay":""}]'
				            data-responsive_offset="on" 

				            data-startslide="0" 
				            data-endslide="11" 
				            data-frames='[{"from":"opacity:0;","speed":300,"to":"o:1;sX:0.5;sY:0.5;","delay":500,"ease":"Power2.easeInOut"},{"delay":"wait","speed":300,"to":"opacity:0;","ease":"nothing"},{"frame":"hover","speed":"500","ease":"Power2.easeInOut","to":"o:1;sX:0.7;sY:0.7;rX:0;rY:0;rZ:0;z:0;","style":"c:rgba(255, 255, 255, 1.00);"}]'
				            data-textAlign="['left','left','left','left']"
				            data-paddingtop="[0,0,0,0]"
				            data-paddingright="[0,0,0,0]"
				            data-paddingbottom="[0,0,0,0]"
				            data-paddingleft="[0,0,0,0]"

				            style="z-index: 77;text-transform:left;border-width:0px;cursor:pointer;"><img src="<?php echo e(asset('img/sistemas/smart-fit-colchones-carreiro.png')); ?>" alt="" data-ww="['150px','100px','100px','100px']" data-hh="['auto']" data-no-retina> </div>

				        <!-- LAYER NR. 64 -->
				        <div class="tp-caption   tp-resizeme tp-static-layer" 
				            id="slider-1082-layer-8" 
				            data-x="['center','center','center','center']" data-hoffset="['150','120','90','-120']"
				            data-y="['top','top','top','top']" data-voffset="['0','50','50','80']" 
				            data-width="none"
				            data-height="none"
				            data-whitespace="nowrap"
				 
				            data-type="image" 
				            data-actions='[{"event":"mouseenter","action":"jumptoslide","slide":"rs-3069","delay":""}]'
				            data-responsive_offset="on" 

				            data-startslide="0" 
				            data-endslide="11" 
				            data-frames='[{"from":"opacity:0;","speed":300,"to":"o:1;sX:0.5;sY:0.5;","delay":500,"ease":"Power2.easeInOut"},{"delay":"wait","speed":300,"to":"opacity:0;","ease":"nothing"},{"frame":"hover","speed":"500","ease":"Power2.easeInOut","to":"o:1;sX:0.7;sY:0.7;rX:0;rY:0;rZ:0;z:0;","style":"c:rgba(255, 255, 255, 1.00);"}]'
				            data-textAlign="['left','left','left','left']"
				            data-paddingtop="[0,0,0,0]"
				            data-paddingright="[0,0,0,0]"
				            data-paddingbottom="[0,0,0,0]"
				            data-paddingleft="[0,0,0,0]"

				            style="z-index: 78;text-transform:left;border-width:0px;cursor:pointer;"><img src="<?php echo e(asset('img/sistemas/soft-dream-colchones-carreiro.png')); ?>" alt="" data-ww="['150px','100px','100px','100px']" data-hh="['auto']" data-no-retina> </div>

			            <!-- LAYER NR. 65 -->
				        <div class="tp-caption   tp-resizeme tp-static-layer" 
				            id="slider-1082-layer-9" 
				            data-x="['center','center','center','center']" data-hoffset="['250','200','150','-40']" 
				            data-y="['top','top','top','top']" data-voffset="['0','50','50','80']" 
				            data-width="none"
				            data-height="none"
				            data-whitespace="nowrap"
				 
				            data-type="image" 
				            data-actions='[{"event":"mouseenter","action":"jumptoslide","slide":"rs-3070","delay":""}]'
				            data-responsive_offset="on" 

				            data-startslide="0" 
				            data-endslide="11" 
				            data-frames='[{"from":"opacity:0;","speed":300,"to":"o:1;sX:0.5;sY:0.5;","delay":500,"ease":"Power2.easeInOut"},{"delay":"wait","speed":300,"to":"opacity:0;","ease":"nothing"},{"frame":"hover","speed":"500","ease":"Power2.easeInOut","to":"o:1;sX:0.7;sY:0.7;rX:0;rY:0;rZ:0;z:0;","style":"c:rgba(255, 255, 255, 1.00);"}]'
				            data-textAlign="['left','left','left','left']"
				            data-paddingtop="[0,0,0,0]"
				            data-paddingright="[0,0,0,0]"
				            data-paddingbottom="[0,0,0,0]"
				            data-paddingleft="[0,0,0,0]"

				            style="z-index: 79;text-transform:left;border-width:0px;cursor:pointer;"><img src="<?php echo e(asset('img/sistemas/superior-foam-colchones-carreiro.png')); ?>" alt="" data-ww="['150px','100px','100px','100px']" data-hh="['auto']" data-no-retina> </div>

			            <!-- LAYER NR. 66 -->
				        <div class="tp-caption   tp-resizeme tp-static-layer" 
				            id="slider-1082-layer-10" 
				            data-x="['center','center','center','center']" data-hoffset="['350','280','210','40']" 
				            data-y="['top','top','top','top']" data-voffset="['0','50','50','80']" 
				            data-width="none"
				            data-height="none"
				            data-whitespace="nowrap"
				 
				            data-type="image" 
				            data-actions='[{"event":"mouseenter","action":"jumptoslide","slide":"rs-3071","delay":""}]'
				            data-responsive_offset="on" 

				            data-startslide="0" 
				            data-endslide="11" 
				            data-frames='[{"from":"opacity:0;","speed":300,"to":"o:1;sX:0.5;sY:0.5;","delay":500,"ease":"Power2.easeInOut"},{"delay":"wait","speed":300,"to":"opacity:0;","ease":"nothing"},{"frame":"hover","speed":"500","ease":"Power2.easeInOut","to":"o:1;sX:0.7;sY:0.7;rX:0;rY:0;rZ:0;z:0;","style":"c:rgba(255, 255, 255, 1.00);"}]'
				            data-textAlign="['left','left','left','left']"
				            data-paddingtop="[0,0,0,0]"
				            data-paddingright="[0,0,0,0]"
				            data-paddingbottom="[0,0,0,0]"
				            data-paddingleft="[0,0,0,0]"

				            style="z-index: 80;text-transform:left;border-width:0px;cursor:pointer;"><img src="<?php echo e(asset('img/sistemas/twist-colchones-carreiro.png')); ?>" alt="" data-ww="['150px','100px','100px','100px']" data-hh="['auto']" data-no-retina> </div>

			             <!-- LAYER NR. 67 -->
				        <div class="tp-caption   tp-resizeme tp-static-layer" 
				            id="slider-1082-layer-10" 
				            data-x="['center','center','center','center']" data-hoffset="['450','360','270','120']" 
				            data-y="['top','top','top','top']" data-voffset="['0','50','50','80']" 
				            data-width="none"
				            data-height="none"
				            data-whitespace="nowrap"
				 
				            data-type="image" 
				            data-actions='[{"event":"mouseenter","action":"jumptoslide","slide":"rs-3072","delay":""}]'
				            data-responsive_offset="on" 

				            data-startslide="0" 
				            data-endslide="11"
				            data-frames='[{"from":"opacity:0;","speed":300,"to":"o:1;sX:0.5;sY:0.5;","delay":500,"ease":"Power2.easeInOut"},{"delay":"wait","speed":300,"to":"opacity:0;","ease":"nothing"},{"frame":"hover","speed":"500","ease":"Power2.easeInOut","to":"o:1;sX:0.7;sY:0.7;rX:0;rY:0;rZ:0;z:0;","style":"c:rgba(255, 255, 255, 1.00);"}]'
				            data-textAlign="['left','left','left','left']"
				            data-paddingtop="[0,0,0,0]"
				            data-paddingright="[0,0,0,0]"
				            data-paddingbottom="[0,0,0,0]"
				            data-paddingleft="[0,0,0,0]"

				            style="z-index: 81;text-transform:left;border-width:0px;cursor:pointer;"><img src="<?php echo e(asset('img/sistemas/up-turn-colchones-carreiro.png')); ?>" alt="" data-ww="['150px','100px','100px','100px']" data-hh="['auto']" data-no-retina> </div>

			             <!-- LAYER NR. 67 -->
				        <div class="tp-caption   tp-resizeme tp-static-layer" 
				            id="slider-1082-layer-11" 
				            data-x="['center','center','center','center']" data-hoffset="['550','440','330','200']" 
				            data-y="['top','top','top','top']" data-voffset="['0','50','50','80']" 
				            data-width="none"
				            data-height="none"
				            data-whitespace="nowrap"
				 
				            data-type="image" 
				            data-actions='[{"event":"mouseenter","action":"jumptoslide","slide":"rs-3073","delay":""}]'
				            data-responsive_offset="on" 

				            data-startslide="0" 
				            data-endslide="11"
				            data-frames='[{"from":"opacity:0;","speed":300,"to":"o:1;sX:0.5;sY:0.5;","delay":500,"ease":"Power2.easeInOut"},{"delay":"wait","speed":300,"to":"opacity:0;","ease":"nothing"},{"frame":"hover","speed":"500","ease":"Power2.easeInOut","to":"o:1;sX:0.7;sY:0.7;rX:0;rY:0;rZ:0;z:0;","style":"c:rgba(255, 255, 255, 1.00);"}]'
				            data-textAlign="['left','left','left','left']"
				            data-paddingtop="[0,0,0,0]"
				            data-paddingright="[0,0,0,0]"
				            data-paddingbottom="[0,0,0,0]"
				            data-paddingleft="[0,0,0,0]"

				            style="z-index: 81;text-transform:left;border-width:0px;cursor:pointer;"><img src="<?php echo e(asset('img/sistemas/free-vent-colchones-carreiro.png')); ?>" alt="" data-ww="['150px','100px','100px','100px']" data-hh="['auto']" data-no-retina> </div>
					</div>
					<div class="tp-bannertimer tp-bottom" style="visibility: hidden !important;"></div> 
				</div>
			</div><!-- END REVOLUTION SLIDER -->
        
        </article>
    </section>
    <section id="clientes" class="py-5">
    	<div class="container">
    		<div class="row">
    			<div class="col">
    				<h2 class="ralewal_bold text-uppercase text-center azul h3 mx-auto px-3"><span class="raleway_light">quienes han </span>confiado en nosotros</h2>
    				<hr>
    			</div>
    		</div>
    		<div class="row">
    			<div class="col py-3">
    				<div id="basicExample">
    					<?php
    						$dir = "./img/clientes/";
							// Abre un directorio conocido, y procede a leer el contenido
							if (is_dir($dir)) {
							    if ($dh = opendir($dir)) {
							        while (($file = readdir($dh)) !== false) { ?>
							            <a href="<?php echo e($file); ?>">
							            	<img alt="caption for image 1" src="<?php echo e(asset("img/clientes/$file")); ?>"/>
						            	</a>
							        <?php }
							        closedir($dh);
							    }
							} else {
								echo "no";
								echo $dir;
							}
    					?>
    				</div>
    			</div>
    		</div>
    	</div>
    </section>
	<?php echo $__env->make('includes.footer', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
	<!-- Modal -->
	<div class="modal fade" id="modal-imagen-alta" tabindex="-1" role="dialog" aria-labelledby="modal-imagen-altaLabel" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
			<div class="modal-content">
				<div class="modal-header d-none">
					<h5 class="modal-title" id="modal-imagen-altaLabel">Modal title</h5>
				</div>
				<div class="modal-body">
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
					<img src="" class="img-fluid mx-auto d-block lazy-load">
				</div>
				<div class="modal-footer d-none">
					<button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
					<button type="button" class="btn btn-primary">Save changes</button>
				</div>
			</div>
		</div>
	</div>

	<!-- jQuery first, then Popper.js, then Bootstrap JS -->
    <script src="<?php echo e(asset('jquery/jquery-3.3.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset('popper/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bootstrap-4/js/bootstrap.min.js')); ?>"></script>
    
    <script src="<?php echo e(asset('font-awesome-5.0.8/all.js')); ?>"></script>
    
    <script src="<?php echo e(asset('elevatezoom-master/jquery.elevateZoom-3.0.8.min.js')); ?>"></script>
    

    <!-- REVOLUTION JS FILES -->
    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/jquery.themepunch.tools.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/jquery.themepunch.revolution.min.js')); ?>"></script>

    
    <script type='text/javascript' src='<?php echo e(asset('slider-revolution/revolution-addons/particles/js/revolution.addon.particles.min.js')); ?>'></script>

    <!-- SLIDER REVOLUTION 5.0 EXTENSIONS  (Load Extensions only on Local File Systems !  The following part can be removed on Server for On Demand Loading) -->    
    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/extensions/revolution.extension.actions.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/extensions/revolution.extension.carousel.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/extensions/revolution.extension.kenburn.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/extensions/revolution.extension.layeranimation.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/extensions/revolution.extension.migration.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/extensions/revolution.extension.navigation.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/extensions/revolution.extension.parallax.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/extensions/revolution.extension.slideanims.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/extensions/revolution.extension.video.min.js')); ?>"></script>



	
	<script src="<?php echo e(asset('slick-1.8.0/slick.min.js')); ?>"></script>
	
	<script src="<?php echo e(asset('Justified-Gallery/js/jquery.justifiedGallery.min.js')); ?>"></script>
    
    <script src="<?php echo e(asset('js/globales.js')); ?>"></script>
    <script src="<?php echo e(asset('js/hotelero.js')); ?>"></script>
    <script>var path = '<?php echo e(Request::root()); ?>';</script>
	<script type="text/javascript">
		var tpj=jQuery;
            
        var revapi1082;
        tpj(document).ready(function() {
            if(tpj("#rev_slider_1082_1").revolution == undefined){
                revslider_showDoubleJqueryError("#rev_slider_1082_1");
            }else{
                revapi1082 = tpj("#rev_slider_1082_1").show().revolution({
                    sliderType:"standard",
                    jsFileLocation:"revolution/js/",
                    sliderLayout:"auto",
                    dottedOverlay:"none",
                    delay:9000,
                    navigation: {
                        onHoverStop:"off",
                    },
                    responsiveLevels:[1240,1024,778,480],
                    visibilityLevels:[1240,1024,778,480],
                    gridwidth:[1400,1024,778,480],
                    gridheight:[450,700,600,700],
                    lazyType:"none",
                    shadow:0,
                    spinner:"off",
                    stopLoop:"on",
                    stopAfterLoops:0,
                    stopAtSlide:1,
                    shuffle:"off",
                    autoHeight:"off",
                    disableProgressBar:"on",
                    hideThumbsOnMobile:"off",
                    hideSliderAtLimit:0,
                    hideCaptionAtLimit:0,
                    hideAllCaptionAtLilmit:0,
                    debugMode:false,
                    fallbacks: {
                        simplifyAll:"off",
                        nextSlideOnWindowFocus:"off",
                        disableFocusListener:false,
                    },
                    particles: {startSlide: "first", endSlide: "last", zIndex: "1",
                    particles: {
                    	number: {value: 80}, color: {value: "#ffffff"},
                    	shape: {
                    		type: "circle", stroke: {width: 0, color: "#ffffff", opacity: 1},
                    		image: {src: ""}
                    	},
                    	opacity: {value: 0.5, random: true, min: 0.25, anim: {enable: false, speed: 3, opacity_min: 0, sync: false}},
                    	size: {value: 2, random: false, min: 30, anim: {enable: false, speed: 40, size_min: 1, sync: false}},
                    	line_linked: {enable: true, distance: 150, color: "#ffffff", opacity: 0.4, width: 1},
                    	move: {enable: true, speed: 6, direction: "none", random: true, min_speed: 6, straight: false, out_mode: "out"}},
                    	interactivity: {
                    		events: {onhover: {enable: false, mode: "repulse"}, onclick: {enable: false, mode: "repulse"}},
                    		modes: {grab: {distance: 400, line_linked: {opacity: 0.5}}, bubble: {distance: 400, size: 40, opacity: 0.4}, repulse: {distance: 200}}
                    	}
                    }
                });
                RsParticlesAddOn(revapi1082);
            }
        }); /*ready*/
    </script>
</body>
</html>