<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>">
<head>
	<?php
		$titulo = "Línea Médico Hospitalario | Colchones Carreiro";
		$descripcion = "Fabricamos colchones para el sector médico hospitalario, el colchón perfecto para la recuperación de sus pacientes. Colchón clínico especialmente fabricado para su hospital, con la comodidad que sus pacientes necesitan para su recuperación."
	?>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('bootstrap-4/css/bootstrap.min.css')); ?>" >
    
    <link rel="stylesheet" href="<?php echo e(asset('slick-1.8.0/slick.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('slick-1.8.0/slick-theme.css')); ?>">
	<!-- Coloca este código dentro de la etiqueta <head> de tu web -->
	<title><?php echo e($titulo); ?></title>
	<meta name="description" content="<?php echo e($descripcion); ?>" />

	<!-- Twitter Card data -->
	<meta name="twitter:card" value="summary_large">

	<!-- Open Graph data -->
	<meta property="og:title" content="<?php echo e($titulo); ?>" />
	<meta property="og:type" content="website" />
	<meta property="og:url" content="<?php echo e(Request::fullUrl()); ?>" />
	<meta property="og:image" content="<?php echo e(asset('img/colchones/clinico/redes-sociales-colchon-clinico-colchones-carreiro.jpg')); ?>" />
	<meta property="og:description" content="<?php echo e($descripcion); ?>" />
	
	
	
	<link rel="stylesheet" type="text/css" href="<?php echo e(asset('slider-revolution/revolution/fonts/pe-icon-7-stroke/css/pe-icon-7-stroke.css')); ?>">
	<link rel="stylesheet" type="text/css" href="<?php echo e(asset('slider-revolution/revolution/fonts/font-awesome/css/font-awesome.css')); ?>">    
    <!-- REVOLUTION STYLE SHEETS -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('slider-revolution/revolution/css/settings.css')); ?>">
    <!-- REVOLUTION LAYERS STYLES -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('slider-revolution/revolution/css/layers.css')); ?>">
    <!-- REVOLUTION NAVIGATION STYLES -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('slider-revolution/revolution/css/navigation.css')); ?>">



	
	<link rel="stylesheet" href="<?php echo e(asset('slick-1.8.0/slick.css')); ?>">
	
	<link rel="stylesheet" href="<?php echo e(asset('css/fuentes.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('css/globales.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('css/clinico.css')); ?>">
</head>
<body>
	<div id="loader" class="d-flex align-items-center justify-content-center">
		<div>
			<img src="<?php echo e(asset("img/logos/isologo-linea-$linea-colchones-carreiro.svg")); ?>" alt="<?php echo e($titulo); ?>" class="img-fluid mx-auto d-block" width="200">
			<img src="<?php echo e(asset('img/loader.svg')); ?>" alt="<?php echo e($titulo); ?>" class="img-fluid mx-auto d-block" width="100">
		</div>
	</div>
	<?php echo $__env->make('includes.header', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
	<section class="ajuste_menu">
		<div class="rev_slider_wrapper fullscreen-container">
		 
		    <!-- the ID here will be used in the inline JavaScript below to initialize the slider -->
		    <div id="rev_slider_1" class="rev_slider fullscreenbanner tp-overflow-hidden" data-version="5.4.7.2" style="display:none">
		 
		        <ul>
		            <!-- SLIDE 1 -->
				    <li data-transition="papercut">
				 
				        <!-- SLIDE'S MAIN BACKGROUND IMAGE -->
				        <img src="<?php echo e(asset('img/fondos/linea-clinico-colchones-carreiro.jpg')); ?>" alt="<?php echo e($titulo); ?>" class="rev-slidebg" data-bgposition="center center" data-bgfit="cover" data-bgrepeat="no-repeat" data-bgparallax="5">

				        <!-- LAYER 1 IMAGE-->
						<div class="tp-caption tp-resizeme" 
						 
						   data-frames='[{"delay":0,"speed":3000,"frame":"0","from":"x:right;","to":"o:1;","ease":"Power3.easeInOut"},{"delay":"wait","speed":300,"frame":"999","to":"auto:auto;","ease":"Power3.easeInOut"}]'
						 
						     data-type="image" 
						     data-x="['right','right','center','center']" 
						     data-y="center" 
						     data-hoffset="['90','30','0','0']" 
						     data-voffset="['50','50','-175','-70']" 
						     data-width="['auto']"
						     data-height="['auto']"

						     data-basealign="grid" 
						     data-responsive_offset="off"
						 
						><img src="<?php echo e(asset('img/colchones/clinico/colchon-clinico-colchones-carreiro-abierto.png')); ?>" alt="Colchon Clínico <?php echo e($titulo); ?>" data-ww="['600px','550px','400px','400px']" data-hh="['auto']" data-abierta="<?php echo e(asset('img/colchones/clinico/colchon-clinico-colchones-carreiro.png')); ?>" data-original="<?php echo e(asset('img/colchones/clinico/colchon-clinico-colchones-carreiro-abierto.png')); ?>" class="imagen-abierta"></div>

						<!-- LAYER 2 IMAGE-->
						<div class="tp-caption tp-resizeme" 
						 
						    data-frames='[{"delay":0,"speed":2000,"frame":"0","from":"y:top;","to":"o:1;","ease":"Power3.easeInOut"},{"delay":"wait","speed":300,"frame":"999","to":"auto:auto;","ease":"Power3.easeInOut"}]'
						 
						     data-type="image" 
						     data-x="center" 
						     data-y="top" 
						     data-hoffset="0" 
						     data-voffset="['50','50','50','10']" 
						     data-width="['auto']"
						     data-height="['auto']"

						     data-basealign="slide" 
						     data-responsive_offset="off"
						 
						><img src="<?php echo e(asset('img/logos/isologo-linea-medico-hospitalario-colchones-carreiro.svg')); ?>" alt="Colchon Clínico <?php echo e($titulo); ?>" data-ww="['200px']" data-hh="['auto']"></div>

						<!-- LAYER  3 TEXT-->
						<div class="tp-caption tp-resizeme" 
						 
						    data-frames='[{"delay":0,"speed":2500,"frame":"0","from":"x:left;","to":"o:1;","ease":"Power3.easeInOut"},{"delay":"wait","speed":300,"frame":"999","to":"auto:auto;","ease":"Power3.easeInOut"}]'

						 
						     data-x="['left','left','center','center']" 
						     data-y="center" 
						     data-hoffset="['120','25','0','0']" 
						     data-voffset="['50','50','175','150']" 
						     data-width="['350']"
						     data-height="['auto']"

						     data-whitespace="['normal']"
						     data-lineheight="'18', '20', '22', '18']"
						     data-fontsize="['18', '20', '22', '18']"

						     data-basealign="grid" 
						     data-responsive_offset="off"
						 
						>
							<div class="raleway_regular text-center fondo_azul blanco py-2 bordes_superiores">SISTEMA DE DESCANSO</div>
							<div class="fondo_blanco py-2">
								<img src="<?php echo e(asset('img/sistemas/iconos/orthopedic-colchones-carreiro.png')); ?>" alt="Sistema Orthopedic <?php echo e($titulo); ?>" class="mx-auto d-block img-fluid" width="100">
							</div>
							<div class="raleway_regular text-center fondo_azul blanco py-2">CARACTERISTICAS</div>
							<div class="raleway_regular fondo_blanco azul bordes_inferiores p-2">
								<small>
								• Una plancha de espuma de 3 cm. de espesor en 20 kg de densidad suave con cuatro canales para flexión.<br>
								• Una plancha de espuma de 10 cm de espuma de 35 kg de densidad.<br>
								• Una plancha de espuma de 3 cm de espesor en 20 kg de densidad suave con cuatro canales para flexión.
								</small>
							</div>
						</div>

						<!-- LAYER 4 IMAGE-->
						<div class="tp-caption tp-resizeme" 
						 
						    data-frames='[{"delay":2000,"speed":800,"frame":"0","from":"x:200px;skX:-85px;opacity:0;","to":"o:1;","ease":"Power3.easeInOut"},{"delay":"wait","speed":300,"frame":"999","to":"auto:auto;","ease":"Power3.easeInOut"}]' 
						 
						     data-type="image" 
						     data-x="['right','right','center','center']" 
						     data-y="center"
						     data-hoffset="['75','25','225','130']" 
						     data-voffset="['25','25','-200','-90']" 
						     data-width="['auto']"
						     data-height="['auto']"

						     data-basealign="grid" 
						     data-responsive_offset="off"
						 
						><img src="<?php echo e(asset('img/colchones/clinico/ignifugo-colchones-carreiro.png')); ?>" alt="Ignifugo Colchon Clínico <?php echo e($titulo); ?>" data-ww="['50px']" data-hh="['auto']"></div>

						<!-- LAYER 5 IMAGE-->
						<div class="tp-caption tp-resizeme" 
						 
						    data-frames='[{"delay":2500,"speed":800,"frame":"0","from":"x:200px;skX:-85px;opacity:0;","to":"o:1;","ease":"Power3.easeInOut"},{"delay":"wait","speed":300,"frame":"999","to":"auto:auto;","ease":"Power3.easeInOut"}]' 
						 
						     data-type="image" 
						     data-x="['right','right','center','center']" 
						     data-y="center" 
						     data-hoffset="['150','87','166','100']" 
						     data-voffset="['100','87','-150','-50']" 
						     data-width="['auto']"
						     data-height="['auto']"

						     data-basealign="grid" 
						     data-responsive_offset="off"
						 
						><img src="<?php echo e(asset('img/colchones/clinico/antiacaros-colchones-carreiro.png')); ?>" alt="Antiacaros Colchon Clínico <?php echo e($titulo); ?>" data-ww="['50px']" data-hh="['auto']"></div>

						<!-- LAYER 4 IMAGE-->
						<div class="tp-caption tp-resizeme" 
						 
						    data-frames='[{"delay":3000,"speed":800,"frame":"0","from":"x:200px;skX:-85px;opacity:0;","to":"o:1;","ease":"Power3.easeInOut"},{"delay":"wait","speed":300,"frame":"999","to":"auto:auto;","ease":"Power3.easeInOut"}]' 
						 
							     data-type="image" 
							     data-x="['right','right','center','center']"
							     data-y="center" 
							     data-hoffset="['225','150','100','50']" 
							     data-voffset="['175','150','-100','-10']" 
							     data-width="['auto']"
							     data-height="['auto']"

							     data-basealign="grid" 
							     data-responsive_offset="off"
						 
						><img src="<?php echo e(asset('img/colchones/clinico/repelente-colchones-carreiro.png')); ?>" alt="Repelente Colchon Clínico <?php echo e($titulo); ?>" data-ww="['50px']" data-hh="['auto']"></div>

				    </li>
		        </ul>
		 
		    </div>
		 
		</div>
	</section>
	<?php echo $__env->make('includes.footer', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
	<!-- jQuery first, then Popper.js, then Bootstrap JS -->
    <script src="<?php echo e(asset('jquery/jquery-3.3.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset('popper/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bootstrap-4/js/bootstrap.min.js')); ?>"></script>
    
    <script src="<?php echo e(asset('font-awesome-5.0.8/all.js')); ?>"></script>
    
    <script src="<?php echo e(asset('elevatezoom-master/jquery.elevateZoom-3.0.8.min.js')); ?>"></script>
    

    <!-- REVOLUTION JS FILES -->
    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/jquery.themepunch.tools.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/jquery.themepunch.revolution.min.js')); ?>"></script>

    <!-- SLIDER REVOLUTION 5.0 EXTENSIONS  (Load Extensions only on Local File Systems !  The following part can be removed on Server for On Demand Loading) -->    
    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/extensions/revolution.extension.actions.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/extensions/revolution.extension.carousel.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/extensions/revolution.extension.kenburn.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/extensions/revolution.extension.layeranimation.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/extensions/revolution.extension.migration.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/extensions/revolution.extension.navigation.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/extensions/revolution.extension.parallax.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/extensions/revolution.extension.slideanims.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/extensions/revolution.extension.video.min.js')); ?>"></script>



	
	<script src="<?php echo e(asset('slick-1.8.0/slick.min.js')); ?>"></script>
    
    <script src="<?php echo e(asset('js/globales.js')); ?>"></script>
    <script src="<?php echo e(asset('js/clinico.js')); ?>"></script>
    <script>var path = '<?php echo e(Request::root()); ?>';</script>
    <script type="text/javascript">

	    /* https://learn.jquery.com/using-jquery-core/document-ready/ */
	    jQuery(document).ready(function() {
	 
	        /* initialize the slider based on the Slider's ID attribute */
	        jQuery('#rev_slider_1').show().revolution({
	 
	            /* options are 'auto', 'fullwidth' or 'fullscreen' */
	            sliderLayout: 'fullscreen',

				/* OFFSET SLIDER BY THE HEIGHT OF AN ELEMENT */
				fullScreenOffsetContainer: "nav",

				/* RESPECT ASPECT RATIO */
				autoHeight: 'off',

				/* MIN-HEIGHT */
				minHeight: '500',

				responsiveLevels: [1240, 1024, 778, 480],
				gridwidth:[1240, 1024, 778, 480],
				gridheight:[400, 768, 960, 720],

				/* [DESKTOP, LAPTOP, TABLET, SMARTPHONE] */
				visibilityLevels:[1240, 1024, 1024, 480],

				/* PRELOADER OPTION "3" */
				spinner: 'spinner3',

				parallax: {
			        type: 'mouse+scroll',
			        origo: 'slidercenter',
			        speed: 400,
			        levels: [5,10,15,20,25,30,35,40,
			                 45,46,47,48,49,50,51,55],
			        disable_onmobile: 'on'
			    },
	 
	            /* basic navigation arrows and bullets */
	            navigation: {
	 
	                arrows: {
	                    enable: false,
	                    style: 'hesperiden',
	                    hide_onleave: false
	                },
	 
	                bullets: {
	                    enable: false,
	                    style: 'hesperiden',
	                    hide_onleave: false,
	                    h_align: 'center',
	                    v_align: 'bottom',
	                    h_offset: 0,
	                    v_offset: 20,
	                    space: 5
	                }
	            }
	        });
	    });
	 
	</script>
</body>
</html>