<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>">
<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('bootstrap-4/css/bootstrap.min.css')); ?>" >
    
    <link rel="stylesheet" href="<?php echo e(asset('animate-css/animate.css')); ?>">
	<!-- Coloca este código dentro de la etiqueta <head> de tu web -->
	<title>Colchones Carreiro</title>
	<meta name="description" content="Visita nuestro sitio y encuentra el colchón perfecto para tu descanso. Colchones Carreiro® ¡Por tradición!" />

	<!-- Twitter Card data -->
	<meta name="twitter:card" value="summary_large">

	<!-- Open Graph data -->
	<meta property="og:title" content="Colchones Carreiro" />
	<meta property="og:type" content="website" />
	<meta property="og:url" content="<?php echo e(Request::fullUrl()); ?>" />
	<meta property="og:image" content="<?php echo e(asset('img/logos/imagotipo-azul-colchones-carreiro.png')); ?>" />
	<meta property="og:description" content="Visita nuestro sitio y encuentra el colchón perfecto para tu descanso. Colchones Carreiro® ¡Por tradición!" />
	
	<link rel="stylesheet" href="<?php echo e(asset('css/fuentes.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('css/globales.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('css/sucursales.css')); ?>">
</head>
<body>
	<div id="loader"></div>
	<?php echo $__env->make('includes.header', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
	<p class="raleway_regular text-center blanco mb-0">Da CLIC en <img src="<?php echo e(asset('img/marcador.png')); ?>" alt="Marcador Colchones Carreiro"> para ver la dirección</p>
	<div id="gmap" style="height: 100vh"></div>
	<div class="busqueda text-center">
		<h1 class="raleway_regular blanco h3">BÚSQUEDA EXACTA</h1>
		<p class="raleway_regular blanco">¿Dónde me encuentro?:</p>
		<select class="custom-select">
			<option selected>Selecciona un estado</option>
			
			
			
			
			
			<option value="Colima">Colima</option>
			
			
			<option value="CDMX">CDMX</option>
			
			<option value="Guanajuato">Guanajuato</option>
			
			<option value="Hidalgo">Hidalgo</option>
			<option value="Jalisco">Jalisco</option>
			<option value="Estado de México">Estado de México</option>
			<option value="Michoacán">Michoacán</option>
			<option value="Morelos">Morelos</option>
			
			
			
			<option value="Puebla">Puebla</option>
			<option value="Querétaro">Querétaro</option>
			<option value="Quintana Roo">Quintana Roo</option>
			
			
			
			
			
			<option value="Tlaxcala">Tlaxcala</option>
			
			
			<option value="Zacatecas">Zacatecas</option>
		</select>
		<button type="button" class="btn btn-light mt-3 raleway_bold px-4">Ir</button>
		<img src="<?php echo e(asset('img/right.png')); ?>" alt="Colchones Carreiro" width="40" height="40">
	</div>
	<?php echo $__env->make('includes.footer', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
	<!-- jQuery first, then Popper.js, then Bootstrap JS -->
    <script src="<?php echo e(asset('jquery/jquery-3.3.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset('popper/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bootstrap-4/js/bootstrap.min.js')); ?>"></script>
    
    <script src="<?php echo e(asset('font-awesome-5.0.8/all.js')); ?>"></script>
    
    <script src="<?php echo e(asset('parallax.js-1.5.0/parallax.min.js')); ?>"></script>
    
    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDQ9JuFIoaIPpHeClhr0HFgkzZrHcCjtn4&callback=initMap"
    async defer></script>
	<script type="text/javascript" src="<?php echo e(asset('maplace/maplace.min.js')); ?>"></script>
    
    <script src="<?php echo e(asset('js/globales.js')); ?>"></script>
    <script src="<?php echo e(asset('js/sucursales.js')); ?>"></script>
    <script>var path = '<?php echo e(Request::root()); ?>';</script>
</body>
</html>