


<?php $__env->startSection('titulo', 'Tiendas'); ?>

<?php $__env->startSection('descripcion', 'Visita nuestro sitio y encuentra el colchón perfecto para tu descanso. Colchones Carreiro® ¡Por tradición!'); ?>

<?php $__env->startSection('imagen'); ?>
	<?php echo e(asset('img/redes-sociales/tienda.jpg')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
	<link rel="stylesheet" href="<?php echo e(asset('css/sucursales.css?v=5')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('contenido'); ?>
	<section style="margin-top: 100px;" id="app" class="pt-2 pb-5">
		<div class="container">
			<div class="row align-items-center">
				<div class="col-sm text-center">
					<h1 class="h3 mb-0">Encuentra tu Carreiro en las tiendas de nuestros distribuidores autorizados.</h1>
					<h2 class="h6 mb-4" style="color:#3975a6;">*Si no tienen el modelo que buscas, solicítalo al momento.</h2>
				</div>
				<div class="col-sm-auto">
					<img src="<?php echo e(asset('img/logos/DISTRIBUIDOR OFICIAL.svg?v=1')); ?>" alt="Colchones Carreiro DISTRIBUIDOR OFICIAL" class="img-fluid mx-auto d-block" style="height: 125px;">
				</div>
			</div>
			<div class="row">
				<div class="<?php echo e($ie ? 'd-none' : 'col-md-4'); ?>">
					<form>
						
						<div class="form-group">
							
							<select class="form-control" v-model="estado" @change="BuscarDelegaciones">
								<option value="donde"  disabled selected>¿Dónde me encuentro?</option>
								
								
								
								
								
								<option value="Colima">Colima</option>
								
								
								<option value="Ciudad de México">CDMX</option>
								
								<option value="Guanajuato">Guanajuato</option>
								
								<option value="Hidalgo">Hidalgo</option>
								<option value="Jalisco">Jalisco</option>
								<option value="Estado de México">Estado de México</option>
								<option value="Michoacán de Ocampo">Michoacán</option>
								<option value="Morelos">Morelos</option>
								
								
								
								<option value="Puebla">Puebla</option>
								<option value="Querétaro">Querétaro</option>
								<option value="Quintana Roo">Quintana Roo</option>
								
								<option value="Sinaloa">Sinaloa</option>
								
								
								
								<option value="Tlaxcala">Tlaxcala</option>
								
								
								<option value="Zacatecas">Zacatecas</option>
							</select>
						</div>
			
						<div class="form-group" v-if="estado">
							
							<select class="form-control" v-model="delegacion" @change="BuscarDireccion">
								<option value="alcaldia" disabled selected>Alcaldía o municipio</option>
								<option :value="delegacion" v-for="delegacion in delegaciones">{{ delegacion }}</option>
							</select>
						</div>
							
						
						
						
					</form>

					<?php if($ie): ?>
						<div class="table-responsive" v-if="direcciones != null">
							<table class="table">
								<thead>
									<tr>
										<th>Tienda</th>
										<th>Estado</th>
										<th>Alcaldía / Municipio</th>
										<th>Dirección</th>
									</tr>
								  </thead>
								  <tbody>
								  	<?php $__currentLoopData = $direcciones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $direccion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								  		<tr>
								  			<td><?php echo e($direccion->tienda); ?></td>
								  			<td><?php echo e($direccion->estado->nombre); ?></td>
								  			<td><?php echo e($direccion->delegacion->nombre); ?></td>
								  			<td><?php echo e($direccion->direccion); ?></td>
								  		</tr>
								  	<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								  </tbody>
							</table>
						</div>
					<?php else: ?>
						<div class="table-responsive" v-if="direcciones != null">
							<table class="table">
								<thead>
									<tr>
										<th>Tienda</th>
										<th>Direccion</th>
									</tr>
								  </thead>
								  <tbody>
								  	<tr v-for="direccion in direcciones">
								  		<td>{{ direccion.tienda }}</td>
								  		<td>{{ direccion.direccion }}</td>
								  	</tr>
								  </tbody>
							</table>
						</div>
						<template v-if="direcciones != null">
							<div v-if="!direcciones.length" class="alert alert-danger" role="alert">Por el momento no tenemos una sucursal en esta ubicación</div>
						</template>
					<?php endif; ?>
				</div>
				<div class="<?php echo e($ie ? 'col' : 'col-md-8'); ?> order-1 order-md-2">
					<div id="gmap" style="height: 500px;"></div>
				</div>
			</div>
		</div>
	</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
	
    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCrNGRpU78bQ1hlGOrAZ3ynNdbWXZAYD44&callback=initMap"></script>
	<script type="text/javascript" src="<?php echo e(asset('maplace/maplace.min.js')); ?>"></script>
	<script src="<?php echo e(asset('js/sucursales.js?v=16')); ?>"></script>
	
	<script src="https://cdn.jsdelivr.net/npm/vue/dist/vue.js"></script>
	<script src="https://unpkg.com/axios/dist/axios.min.js"></script>
	<script>
		new Vue({
			el: '#app',
			data: {
				estado: 'donde',
				delegacion: 'alcaldia',
				delegaciones: null,
				direcciones: null
			},
			methods: {
				BuscarDelegaciones: function (argument) {
					axios
						.get('<?php echo e(url('direccion')); ?>/'+this.estado)
						.then(response => (this.delegaciones = response.data))
				},
				BuscarDireccion: function (argument) {
					if (this.delegacion == 'N/D') {
						this.delegacion = 'N-D'
					}
					axios
						.get('<?php echo e(url('direccion')); ?>/'+this.estado+'/'+this.delegacion)
						.then(response => (this.direcciones = response.data))
				}
			}
		});
	</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>