<!DOCTYPE html>
<html lang="es">
<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('bootstrap-4/css/bootstrap.min.css')); ?>" >
	<!-- Coloca este código dentro de la etiqueta <head> de tu web -->
	<title><?php echo e(str_replace('-', ' ', $colchon)); ?> | Colchones Carreiro</title>
	<meta name="description" content="Visita nuestro sitio y encuentra el colchón perfecto para tu descanso. Colchones Carreiro® ¡Por tradición!" />

	<!-- Twitter Card data -->
	<meta name="twitter:card" value="summary_large">

	<!-- Open Graph data -->
	<meta property="og:title" content="<?php echo e(str_replace('-', ' ', $colchon)); ?> | Colchones Carreiro" />
	<meta property="og:type" content="website" />
	<meta property="og:url" content="<?php echo e(Request::fullUrl()); ?>" />
	<meta property="og:image" content="<?php echo e(asset("img/colchones/liverpool/{$colchon}.jpg")); ?>" />
	<meta property="og:description" content="Visita nuestro sitio y encuentra el colchón perfecto para tu descanso. Colchones Carreiro® ¡Por tradición!" />
</head>
<body>
	<div class="container-fluid">
		<div class="row">
			<div class="col"><img src="<?php echo e(asset("img/colchones/liverpool/{$colchon}.jpg")); ?>" alt="<?php echo e($colchon); ?>" class="img-fluid mx-auto d-block"></div>
		</div>
	</div>
</body>
</html>