<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>">
<head>
	<?php
		$titulo = "Linea Hogar | Colchones Carreiro";
	?>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('bootstrap-4/css/bootstrap.min.css')); ?>" >
    
    <link rel="stylesheet" href="<?php echo e(asset('slick-1.8.0/slick.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('slick-1.8.0/slick-theme.css')); ?>">
	<!-- Coloca este código dentro de la etiqueta <head> de tu web -->
	<title>Colchones Carreiro</title>
	<meta name="description" content="Visita nuestro sitio y encuentra el colchón perfecto para tu descanso. Colchones Carreiro® ¡Por tradición!" />

	<!-- Twitter Card data -->
	<meta name="twitter:card" value="summary_large">

	<!-- Open Graph data -->
	<meta property="og:title" content="Colchones Carreiro" />
	<meta property="og:type" content="website" />
	<meta property="og:url" content="{{ Request::fullUrl() }}" />
	<meta property="og:image" content="<?php echo e(asset('img/logos/imagotipo-azul-colchones-carreiro.png')); ?>" />
	<meta property="og:description" content="Visita nuestro sitio y encuentra el colchón perfecto para tu descanso. Colchones Carreiro® ¡Por tradición!" />
	
	
	
	<link rel="stylesheet" type="text/css" href="<?php echo e(asset('slider-revolution/revolution/fonts/pe-icon-7-stroke/css/pe-icon-7-stroke.css')); ?>">
	<link rel="stylesheet" type="text/css" href="<?php echo e(asset('slider-revolution/revolution/fonts/font-awesome/css/font-awesome.css')); ?>">    
    <!-- REVOLUTION STYLE SHEETS -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('slider-revolution/revolution/css/settings.css')); ?>">
    <!-- REVOLUTION LAYERS STYLES -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('slider-revolution/revolution/css/layers.css')); ?>">
    <!-- REVOLUTION NAVIGATION STYLES -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('slider-revolution/revolution/css/navigation.css')); ?>">



	
	<link rel="stylesheet" href="<?php echo e(asset('slick-1.8.0/slick.css')); ?>">
	
	<link rel="stylesheet" href="<?php echo e(asset('css/fuentes.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('css/globales.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('css/colchones.css')); ?>">
</head>
<body>
	<div id="loader" class="d-flex align-items-center justify-content-center">
		<div>
			<img src="<?php echo e(asset("img/logos/isologo-linea-$linea-colchones-carreiro.svg")); ?>" alt="<?php echo e($titulo); ?>" class="img-fluid mx-auto d-block" width="200">
			<img src="<?php echo e(asset('img/loader.svg')); ?>" alt="<?php echo e($titulo); ?>" class="img-fluid mx-auto d-block" width="100">
		</div>
	</div>
	<?php echo $__env->make('includes.header', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
	<?php
		use Jenssegers\Agent\Agent;
		$agent = new Agent();
	?>
	<?php if($agent->isMobile() || $agent->isTablet()): ?>
		<section id="mobil">
			<div class="container-fluid">
				<div class="row">
					<div class="col text-center">
						<h1 class="lobster azul "><?php echo e($colchon[0] -> nombre); ?></h1>
						<h6 class="raleway_italic azul"><small><?php echo e($colchon[0] -> frase); ?></small></h6>
						<div>
							<img src="<?php echo e(asset('img/iconos/garantia-colchones-carreiro.svg')); ?>" alt="Garantia  Colchones Carreiro" width="100">
							<img src="<?php echo e(asset('img/iconos/donde-compro-mi-colchon.svg')); ?>" alt="Donde Compro mi colchon" width="100">
							<img src="<?php echo e(asset('img/colchones/alta/'.$colchon[0] -> imagen.'')); ?>" alt="<?php echo e($colchon[0] -> nombre); ?>" class="img-fluid mx-auto d-block">
						</div>
						<img src="<?php echo e(asset('img/logos/isologo-linea-hogar-colchones-carreiro.svg')); ?>" alt="<?php echo e($titulo); ?>" width="100" class="img-fluid mx-auto d-block mb-3">
					</div>
				</div>
				<div class="row">
					<div class="col-10 mx-auto">
						<div class="row">
			            	<div class="col-12 fondo_azul bordes-superiores">
			            		<h4 class="raleway_regular blanco mb-0 py-2 h6 text-center">SISTEMAS DE DESCANSO</h4>
			            	</div>
			            </div>
			            <div class="row fondo_blanco">
			            	<div class="col-auto mx-auto py-2 <?php if($tiene_secundarios): ?> border-right <?php endif; ?>">
			            		<h5 class="raleway_regular mb-2 h6 text-center">Principal</h5>
			            		<img src="<?php echo e(asset('img/sistemas/iconos/'.$colchon[0] -> sistema_principal.'')); ?>" alt="" title="" class="img-fluid mx-auto d-block" style="max-width:70px !important; max-height: 70px !important">
			            	</div>
			            	<?php if($tiene_secundarios): ?>
			            		<div class="col-auto mx-auto py-2">
			            			<h5 class="raleway_regular mb-2 h6 text-center">Secundarios</h5>
			            			<ul class="list-inline">
			            				<?php if($colchon[0] -> sistema_comfort_tech): ?>
			            					<li class="list-inline-item">
			            						<img src="<?php echo e(asset('img/sistemas/iconos/comfort-tech-colchones-carreiro.png')); ?>" alt="" class="mx-auto img-fluid d-block" style="max-width:70px !important; max-height: 70px !important">
			            					</li>
			            				<?php endif; ?>
			            				<?php if($colchon[0] -> sistema_flame_proof): ?>
			            					<li class="list-inline-item">
			            						<img src="<?php echo e(asset('img/sistemas/iconos/flame-proof-colchones-carreiro.png')); ?>" alt="" class="mx-auto img-fluid d-block" style="max-width:70px !important; max-height: 70px !important">
			            					</li>
			            				<?php endif; ?>
			            				<?php if($colchon[0] -> sistema_high_resistance): ?>
			            					<li class="list-inline-item">
			            						<img src="<?php echo e(asset('img/sistemas/iconos/high-resistance-colchones-carreiro.png')); ?>" alt="" class="mx-auto img-fluid d-block" style="max-width:70px !important; max-height: 70px !important">
			            					</li>
			            				<?php endif; ?>
			            				<?php if($colchon[0] -> sistema_multizone_technology): ?>
			            					<li class="list-inline-item">
			            						<img src="<?php echo e(asset('img/sistemas/iconos/multizone-technology-colchones-carreiro.png')); ?>" alt="" class="mx-auto img-fluid d-block" style="max-width:70px !important; max-height: 70px !important">
			            					</li>
			            				<?php endif; ?>
			            				<?php if($colchon[0] -> sistema_orthopedic): ?>
			            					<li class="list-inline-item">
			            						<img src="<?php echo e(asset('img/sistemas/iconos/orthopedic-colchones-carreiro.png')); ?>" alt="" class="mx-auto img-fluid d-block" style="max-width:70px !important; max-height: 70px !important">
			            					</li>
			            				<?php endif; ?>
			            				<?php if($colchon[0] -> sistema_smart_fit): ?>
			            					<li class="list-inline-item">
			            						<img src="<?php echo e(asset('img/sistemas/iconos/smart-fit-colchones-carreiro.png')); ?>" alt="" class="mx-auto img-fluid d-block" style="max-width:70px !important; max-height: 70px !important">
			            					</li>
			            				<?php endif; ?>
			            				<?php if($colchon[0] -> sistema_soft_dreams): ?>
			            					<li class="list-inline-item">
			            						<img src="<?php echo e(asset('img/sistemas/iconos/soft-dream-colchones-carreiro.png')); ?>" alt="" class="mx-auto img-fluid d-block" style="max-width:70px !important; max-height: 70px !important">
			            					</li>
			            				<?php endif; ?>
			            				<?php if($colchon[0] -> sistema_superior_foam): ?>
			            					<li class="list-inline-item">
			            						<img src="<?php echo e(asset('img/sistemas/iconos/superior-foam-colchones-carreiro.png')); ?>" alt="" class="mx-auto img-fluid d-block" style="max-width:70px !important; max-height: 70px !important">
			            					</li>
			            				<?php endif; ?>
			            				<?php if($colchon[0] -> sistema_twist): ?>
			            					<li class="list-inline-item">
			            						<img src="<?php echo e(asset('img/sistemas/iconos/twist-colchones-carreiro.png')); ?>" alt="" class="mx-auto img-fluid d-block" style="max-width:70px !important; max-height: 70px !important">
			            					</li>
			            				<?php endif; ?>
			            				<?php if($colchon[0] -> sistema_up_turn): ?>
			            					<li class="list-inline-item">
			            						<img src="<?php echo e(asset('img/sistemas/iconos/up-turn-colchones-carreiro.png')); ?>" alt="" class="mx-auto img-fluid d-block" style="max-width:70px !important; max-height: 70px !important">
			            					</li>
			            				<?php endif; ?>
			            			</ul>
			            		</div>
			            	<?php endif; ?>
			            </div>
			            <div class="row">
			            	<div class="col-12 fondo_azul">
			            		<h4 class="raleway_regular blanco mb-0 py-2 h6 text-center">CARACTERÍSTICAS</h4>
			            	</div>
			            </div>
			            <div class="row">
			            	<div class="col-12 fondo_blanco bordes-inferiores py-2">
			            		<p class="text-left raleway_regular"><small><?php echo e($colchon[0] -> caracteristicas); ?></small></p>
			            	</div>
			            </div>
					</div>
				</div>
			</div>
		</section>
	<?php else: ?>	
		<section class="example ajuste_menu" style="z-index: 11111;">
			<article class="content">
	           
		       <div id="rev_slider_1084_1_wrapper" class="rev_slider_wrapper fullscreen-container" data-alias="web-light-hero" data-source="gallery" style="margin:0px auto;padding:0px;margin-top:0px;margin-bottom:0px;background-image: url('<?php echo e(asset('img/fondos/linea-hogar-colchones-carreiro.jpg')); ?>');background-position: center;background-repeat: no-repeat;background-size: cover;">
		           	<!-- START REVOLUTION SLIDER 5.4.1 fullwidth mode -->
		           	<div id="rev_slider_1084_1" class="rev_slider fullscreenbanner" style="display:none;" data-version="5.4.1">
		           		<ul>    <!-- SLIDE  -->
		           			<li data-index="rs-3074" data-transition="fade" data-slotamount="default" data-hideafterloop="0" data-hideslideonmobile="off"  data-easein="default" data-easeout="default" data-masterspeed="1500"  data-rotate="0"  data-saveperformance="off"  data-title="Intro" data-param1="" data-param2="" data-param3="" data-param4="" data-param5="" data-param6="" data-param7="" data-param8="" data-param9="" data-param10="" data-description="">
		           				<!-- MAIN IMAGE -->
		           				<img src="<?php echo e(asset('img/fondos/nubes-colchones-carreiro.png')); ?>"  alt=""  data-bgposition="center center" data-bgfit="cover" data-bgrepeat="no-repeat" data-bgparallax="5" class="rev-slidebg" data-no-retina>
		           				<!-- LAYERS -->

		           				<!-- LAYER NR. 1 -->
		           				<div class="tp-caption tp-resizeme rs-parallaxlevel-6" 
		       						id="slide-3074-layer-1" 
		       						data-x="['right','right','center','center']" data-hoffset="['150','50','0','0']" 
		       						data-y="['middle']" data-voffset="['-20','-20','-370','-400']" 
		       						data-width="none"
		       						data-height="none"
		       						data-whitespace="nowrap"

		       						data-type="image" 
		       						data-responsive_offset="on" 

		       						data-frames='[{"from":"x:right;","speed":1500,"to":"o:1;","delay":2500,"ease":"Power3.easeOut"},{"delay":"wait","speed":1500,"to":"opacity:0;","ease":"Power4.easeIn"}]'
		       						data-textAlign="['left','left','left','left']"
		       						data-paddingtop="[0,0,0,0]"
		       						data-paddingright="[0,0,0,0]"
		       						data-paddingbottom="[0,0,0,0]"
		       						data-paddingleft="[0,0,0,0]"

		   							style="z-index: 5;text-transform:left;border-width:0px;" data-toggle="modal" data-target="#modal-imagen-alta">
									<img src="<?php echo e(asset('img/colchones/'.$colchon[0] -> imagen.'')); ?>" alt="<?php echo e($colchon[0] -> imagen); ?> Colchones Carreiro" data-ww="['600px','550px','400px','350px']" data-hh="['auto']" data-no-retina>
										<img src="<?php echo e(asset('img/iconos/ver-mas-colchones-carreiro.svg')); ?>" alt="" height="50" data-no-retina style="position: absolute; top: 50%; left: 0; margin-top: -100px; cursor: pointer">
									</div>

						        <!-- LAYER NR. 3 -->
						        <div class="tp-caption   tp-resizeme rs-parallaxlevel-5" 
						             id="slide-3074-layer-12" 
						             data-x="['left','left','left','left']" data-hoffset="['543','543','110','155']" 
						             data-y="['top','top','top','top']" data-voffset="['17','17','500','474']" 
						                        data-width="none"
						            data-height="none"
						            data-whitespace="nowrap"
						 
						            data-type="image" 
						            data-responsive_offset="on" 

						            data-frames='[{"from":"opacity:0;","speed":300,"to":"o:1;","delay":3950,"ease":"Power2.easeInOut"},{"delay":"wait","speed":300,"to":"opacity:0;","ease":"nothing"}]'
						            data-textAlign="['left','left','left','left']"
						            data-paddingtop="[0,0,0,0]"
						            data-paddingright="[0,0,0,0]"
						            data-paddingbottom="[0,0,0,0]"
						            data-paddingleft="[0,0,0,0]"

						            style="z-index: 1;text-transform:left;border-width:0px;">
									<div class="rs-looped rs-slideloop"  data-easing="Linear.easeNone" data-speed="30" data-xs="-600" data-xe="600" data-ys="0" data-ye="0"><img src="<?php echo e(asset('slider-revolution/assets/images/cloud1.png')); ?>" alt="" data-ww="['500px','500px','250','125px']" data-hh="['273px','273px','137','68px']" width="500" height="273" data-no-retina> </div></div>

						        <!-- LAYER NR. 4 
						        <div class="tp-caption   tp-resizeme rs-parallaxlevel-4" 
						             id="slide-3074-layer-3" 
						             data-x="['left','left','center','center']" data-hoffset="['593','633','-110','-60']" 
						             data-y="['top','top','top','bottom']" data-voffset="['183','203','590','20']" 
						                        data-width="none"
						            data-height="none"
						            data-whitespace="nowrap"
						 
						            data-type="image" 
						            data-responsive_offset="on" 

						            data-frames='[{"from":"x:right;","speed":1500,"to":"o:1;","delay":2750,"ease":"Power3.easeOut"},{"delay":"wait","speed":1500,"to":"opacity:0;","ease":"Power4.easeIn"}]'
						            data-textAlign="['left','left','left','left']"
						            data-paddingtop="[0,0,0,0]"
						            data-paddingright="[0,0,0,0]"
						            data-paddingbottom="[0,0,0,0]"
						            data-paddingleft="[0,0,0,0]"

						            style="z-index: 8;text-transform:left;border-width:0px;"><img src="<?php echo e(asset('slider-revolution/assets/images/ipad.png')); ?>" alt="" data-ww="['430px','430px','200px','170px']" data-hh="['540px','540px','251px','213px']" width="430" height="540" data-no-retina> </div>-->

						        <!-- LAYER NR. 5 
						        <div class="tp-caption   tp-resizeme rs-parallaxlevel-4" 
						             id="slide-3074-layer-4" 
						             data-x="['left','left','left','center']" data-hoffset="['663','703','212','-60']" 
						             data-y="['top','top','top','bottom']" data-voffset="['271','291','632','50']" 
						                        data-width="none"
						            data-height="none"
						            data-whitespace="nowrap"
						 
						            data-type="image" 
						            data-responsive_offset="on" 

						            data-frames='[{"from":"z:0;rX:0deg;rY:0;rZ:0;sX:1.5;sY:1.5;skX:0;skY:0;opacity:0;","mask":"x:0px;y:0px;s:inherit;e:inherit;","speed":1500,"to":"o:1;","delay":3700,"ease":"Power3.easeOut"},{"delay":"wait","speed":1500,"to":"opacity:0;","ease":"Power4.easeIn"}]'
						            data-textAlign="['left','left','left','left']"
						            data-paddingtop="[0,0,0,0]"
						            data-paddingright="[0,0,0,0]"
						            data-paddingbottom="[0,0,0,0]"
						            data-paddingleft="[0,0,0,0]"

						            style="z-index: 9;text-transform:left;border-width:0px;"><img src="<?php echo e(asset('slider-revolution/assets/images/ipad_content_new2.jpg')); ?>" alt="" data-ww="['290px','290px','135px','115px']" data-hh="['374px','374px','174px','148px']" width="290" height="374" data-no-retina> </div>-->

						        <!-- LAYER NR. 6 -->
						        <div class="tp-caption   tp-resizeme rs-parallaxlevel-3" 
						             id="slide-3074-layer-13" 
						             data-x="['left','left','left','left']" data-hoffset="['294','294','116','97']" 
						             data-y="['top','top','top','top']" data-voffset="['532','532','745','641']" 
						                        data-width="none"
						            data-height="none"
						            data-whitespace="nowrap"
						 
						            data-type="image" 
						            data-responsive_offset="on" 

						            data-frames='[{"from":"opacity:0;","speed":300,"to":"o:1;","delay":3950,"ease":"Power2.easeInOut"},{"delay":"wait","speed":300,"to":"opacity:0;","ease":"nothing"}]'
						            data-textAlign="['left','left','left','left']"
						            data-paddingtop="[0,0,0,0]"
						            data-paddingright="[0,0,0,0]"
						            data-paddingbottom="[0,0,0,0]"
						            data-paddingleft="[0,0,0,0]"

						            style="z-index: 1;text-transform:left;border-width:0px;">
									<div class="rs-looped rs-slideloop"  data-easing="Linear.easeNone" data-speed="30" data-xs="-400" data-xe="400" data-ys="0" data-ye="0"><img src="<?php echo e(asset('slider-revolution/assets/images/cloud2.png')); ?>" alt="" data-ww="['600px','600px','300','150']" data-hh="['278px','278px','139','70']" width="600" height="278" data-no-retina> </div></div>

						        <!-- LAYER NR. 7 -->
						        <div class="tp-caption tp-resizeme rs-parallaxlevel-2" 
						            id="slide-3074-layer-5" 
						            data-x="['center']" data-hoffset="['-50','80','-230','-200']" 
						            data-y="['top','top','center','center']" data-voffset="['90','85','-480','-480']" 
						            data-width="none"
						            data-height="none"
						            data-whitespace="nowrap"
						 
						            data-type="image" 
						            data-responsive_offset="on" 

						           data-frames='[{"from":"z:0;rX:0deg;rY:0;rZ:0;sX:1.5;sY:1.5;skX:0;skY:0;opacity:0;","mask":"x:0px;y:0px;s:inherit;e:inherit;","speed":1500,"to":"o:1;","delay":3750,"ease":"Power3.easeOut"},{"delay":"wait","speed":1500,"to":"opacity:0;","ease":"Power4.easeIn"}]'
						            data-textAlign="['left','left','left','left']"
						            data-paddingtop="[0,0,0,0]"
						            data-paddingright="[0,0,0,0]"
						            data-paddingbottom="[0,0,0,0]"
						            data-paddingleft="[0,0,0,0]"

						            style="z-index: 11;text-transform:left;border-width:0px;"><img src="<?php echo e(asset('img/iconos/garantia-colchones-carreiro.svg')); ?>" alt="Garantia  Colchones Carreiro" data-ww="['100px']" data-hh="['auto']" data-no-retina> </div>

					            <!-- LAYER NR. 8 copia -->
						        <div class="tp-caption tp-resizeme rs-parallaxlevel-2" 
						            id="slide-3074-layer-6-1" 
						            data-x="['left','left','center','center']" data-hoffset="['150','150','0','0']" 
						            data-y="['top','top','middle','middle']" data-voffset="['30','60','-170','-200']" 
						            data-width="['400','400','100%','100%']"
						            data-height="none"
						            data-whitespace="nowrap"
						 
						            data-type="image" 
						            data-responsive_offset="on" 

						            data-frames='[{"delay":2000,"speed":2000,"frame":"0","from":"y:middle;","to":"o:1;","ease":"Power3.easeInOut"},{"delay":"wait","speed":300,"frame":"999","to":"auto:auto;","ease":"Power3.easeInOut"}]'

						            data-textAlign="['left','left','left','left']"
						            data-paddingtop="[0,0,0,0]"
						            data-paddingright="[0,0,0,0]"
						            data-paddingbottom="[0,0,0,0]"
						            data-paddingleft="[0,0,0,0]"

						            style="z-index: 12;text-transform:left;border-width:0px;"><img src="<?php echo e(asset('img/logos/isologo-linea-hogar-colchones-carreiro.svg')); ?>" alt="Linea Hogar Colchones Carreiro" data-ww="['150px']" data-hh="['auto']" data-no-retina class="mx-auto d-block"> </div>

						        <!-- LAYER NR. 9 -->
						        <div class="tp-caption   tp-resizeme rs-parallaxlevel-1" 
						             id="slide-3074-layer-14" 
						             data-x="['left','left','left','left']" data-hoffset="['280','280','-10','-1']" 
						             data-y="['top','top','top','top']" data-voffset="['223','223','569','518']" 
						                        data-width="none"
						            data-height="none"
						            data-whitespace="nowrap"
						 
						            data-type="image" 
						            data-responsive_offset="on" 

						            data-frames='[{"from":"opacity:0;","speed":300,"to":"o:1;","delay":3950,"ease":"Power2.easeInOut"},{"delay":"wait","speed":300,"to":"opacity:0;","ease":"nothing"}]'
						            data-textAlign="['left','left','left','left']"
						            data-paddingtop="[0,0,0,0]"
						            data-paddingright="[0,0,0,0]"
						            data-paddingbottom="[0,0,0,0]"
						            data-paddingleft="[0,0,0,0]"

						            style="z-index: 1;text-transform:left;border-width:0px;">
									<div class="rs-looped rs-slideloop"  data-easing="Linear.easeNone" data-speed="30" data-xs="-200" data-xe="200" data-ys="0" data-ye="0"><img src="<?php echo e(asset('slider-revolution/assets/images/cloud3.png')); ?>" alt="" data-ww="['600px','600px','300','150']" data-hh="['278px','278px','181','90']" width="738" height="445" data-no-retina> </div></div>

						        <!-- LAYER NR. 10 -->
						        <div class="tp-caption WebProduct-Title tp-resizeme rs-parallaxlevel-7 lobster azul" 
						            id="slide-3074-layer-7" 
						            data-x="['right','right','center','center']" data-hoffset="['150','50','0','0']" 
						            data-y="['top']" data-voffset="['10','10','30','30']" 
					             	data-fontsize="['65','60','55','50']"
						            data-lineheight="['90','90','75','60']"
						            data-width="['600','500','100%','100%']"
						            data-height="none"
						            data-whitespace="nowrap"
						 
						            data-type="text" 
						            data-responsive_offset="on" 

						            data-frames='[{"from":"x:-50px;opacity:0;","speed":1000,"to":"o:1;","delay":1000,"ease":"Power2.easeOut"},{"delay":"wait","speed":1500,"to":"opacity:0;","ease":"Power4.easeIn"}]'
						            data-textAlign="['center','center','center','center']"
						            data-paddingtop="[0,0,0,0]"
						            data-paddingright="[0,0,0,0]"
						            data-paddingbottom="[0,0,0,0]"
						            data-paddingleft="[0,0,0,0]"

						            style="z-index: 14; white-space: nowrap;text-transform:left;"><?php echo e($colchon[0] -> nombre); ?></div>

						        <!-- LAYER NR. 11 -->
						        <div class="tp-caption WebProduct-Content tp-resizeme rs-parallaxlevel-7 raleway_italic azul" 
						            id="slide-3074-layer-9" 
						            data-x="['right','right','center','center']" data-hoffset="['150','50','0','0']" 
						            data-y="['top']" data-voffset="['90','90','100','100']" 
					             	data-fontsize="['16','16','20','14']"
						            data-lineheight="['24','24','24','22']"
						            data-width="['600','500','100%','100%']"
						            data-height="['auto']"
						            data-whitespace="normal"
						 
						            data-type="text" 
						            data-responsive_offset="on" 

						            data-frames='[{"from":"x:-50px;opacity:0;","speed":1000,"to":"o:1;","delay":1500,"ease":"Power2.easeOut"},{"delay":"wait","speed":1500,"to":"opacity:0;","ease":"Power4.easeIn"}]'
						            data-textAlign="['center','center','center','center']"
						            data-paddingtop="[0,0,0,0]"
						            data-paddingright="[0,0,0,0]"
						            data-paddingbottom="[0,0,0,0]"
						            data-paddingleft="[0,0,0,0]"

						            style="z-index: 15; min-width: 700px; max-width: 700px; white-space: normal;text-transform:left;"><?php echo e($colchon[0] -> frase); ?></div>

					            <!-- LAYER NR. 11 copia -->
						        <div class="tp-caption WebProduct-Content tp-resizeme rs-parallaxlevel-7 raleway_italic azul" 
						            id="slide-3074-layer-9-1" 
						            data-x="['left','left','center','center']" data-hoffset="['150','150','0','0']" 
						            data-y="['middle','middle','middle','middle']" data-voffset="['-20','-20','-50','-80']" 
					             	data-fontsize="['25','37','300','300']"
						            data-lineheight="['22','28','100','100']"
						            data-width="['400','430','75%','95%']"
						            data-height="['none','none','81','88']"
						            data-whitespace="normal"
						 
						            data-type="text" 
						            data-responsive_offset="on" 

						            data-frames='[{"from":"x:-50px;opacity:0;","speed":1000,"to":"o:1;","delay":1500,"ease":"Power2.easeOut"},{"delay":"wait","speed":1500,"to":"opacity:0;","ease":"Power4.easeIn"}]'
						            data-textAlign="['center','center','center','center']"
						            data-paddingtop="[0,0,0,0]"
						            data-paddingright="[0,0,0,0]"
						            data-paddingbottom="[0,0,0,0]"
						            data-paddingleft="[0,0,0,0]"

						            style="z-index: 16; min-width: 400px; max-width: 400px; white-space: normal;text-transform:left;">
						            <div class="row">
						            	<div class="col-12 fondo_azul bordes-superiores">
						            		<h4 class="raleway_regular blanco mb-0 py-2 h5">SISTEMAS DE DESCANSO</h4>
						            	</div>
						            </div>
						            <div class="row fondo_blanco">
						            	<div class="col-auto mx-auto py-2 <?php if($tiene_secundarios): ?> border-right <?php endif; ?>">
						            		<h5 class="raleway_regular mb-2">Principal</h5>
						            		<img src="<?php echo e(asset('img/sistemas/iconos/'.$colchon[0] -> sistema_principal.'')); ?>" alt="" title="" class="img-fluid mx-auto d-block" style="max-width:70px !important; max-height: 70px !important">
						            	</div>
						            	<?php if($tiene_secundarios): ?>
						            		<div class="col-auto mx-auto py-2">
						            			<h5 class="raleway_regular mb-2">Secundarios</h5>
						            			<ul class="list-inline">
						            				<?php if($colchon[0] -> sistema_comfort_tech): ?>
						            					<li class="list-inline-item">
						            						<img src="<?php echo e(asset('img/sistemas/iconos/comfort-tech-colchones-carreiro.png')); ?>" alt="" class="mx-auto img-fluid d-block" style="max-width:70px !important; max-height: 70px !important">
						            					</li>
						            				<?php endif; ?>
						            				<?php if($colchon[0] -> sistema_flame_proof): ?>
						            					<li class="list-inline-item">
						            						<img src="<?php echo e(asset('img/sistemas/iconos/flame-proof-colchones-carreiro.png')); ?>" alt="" class="mx-auto img-fluid d-block" style="max-width:70px !important; max-height: 70px !important">
						            					</li>
						            				<?php endif; ?>
						            				<?php if($colchon[0] -> sistema_high_resistance): ?>
						            					<li class="list-inline-item">
						            						<img src="<?php echo e(asset('img/sistemas/iconos/high-resistance-colchones-carreiro.png')); ?>" alt="" class="mx-auto img-fluid d-block" style="max-width:70px !important; max-height: 70px !important">
						            					</li>
						            				<?php endif; ?>
						            				<?php if($colchon[0] -> sistema_multizone_technology): ?>
						            					<li class="list-inline-item">
						            						<img src="<?php echo e(asset('img/sistemas/iconos/multizone-technology-colchones-carreiro.png')); ?>" alt="" class="mx-auto img-fluid d-block" style="max-width:70px !important; max-height: 70px !important">
						            					</li>
						            				<?php endif; ?>
						            				<?php if($colchon[0] -> sistema_orthopedic): ?>
						            					<li class="list-inline-item">
						            						<img src="<?php echo e(asset('img/sistemas/iconos/orthopedic-colchones-carreiro.png')); ?>" alt="" class="mx-auto img-fluid d-block" style="max-width:70px !important; max-height: 70px !important">
						            					</li>
						            				<?php endif; ?>
						            				<?php if($colchon[0] -> sistema_smart_fit): ?>
						            					<li class="list-inline-item">
						            						<img src="<?php echo e(asset('img/sistemas/iconos/smart-fit-colchones-carreiro.png')); ?>" alt="" class="mx-auto img-fluid d-block" style="max-width:70px !important; max-height: 70px !important">
						            					</li>
						            				<?php endif; ?>
						            				<?php if($colchon[0] -> sistema_soft_dreams): ?>
						            					<li class="list-inline-item">
						            						<img src="<?php echo e(asset('img/sistemas/iconos/soft-dream-colchones-carreiro.png')); ?>" alt="" class="mx-auto img-fluid d-block" style="max-width:70px !important; max-height: 70px !important">
						            					</li>
						            				<?php endif; ?>
						            				<?php if($colchon[0] -> sistema_superior_foam): ?>
						            					<li class="list-inline-item">
						            						<img src="<?php echo e(asset('img/sistemas/iconos/superior-foam-colchones-carreiro.png')); ?>" alt="" class="mx-auto img-fluid d-block" style="max-width:70px !important; max-height: 70px !important">
						            					</li>
						            				<?php endif; ?>
						            				<?php if($colchon[0] -> sistema_twist): ?>
						            					<li class="list-inline-item">
						            						<img src="<?php echo e(asset('img/sistemas/iconos/twist-colchones-carreiro.png')); ?>" alt="" class="mx-auto img-fluid d-block" style="max-width:70px !important; max-height: 70px !important">
						            					</li>
						            				<?php endif; ?>
						            				<?php if($colchon[0] -> sistema_up_turn): ?>
						            					<li class="list-inline-item">
						            						<img src="<?php echo e(asset('img/sistemas/iconos/up-turn-colchones-carreiro.png')); ?>" alt="" class="mx-auto img-fluid d-block" style="max-width:70px !important; max-height: 70px !important">
						            					</li>
						            				<?php endif; ?>
						            			</ul>
						            		</div>
						            	<?php endif; ?>
						            </div>
						            <div class="row">
						            	<div class="col-12 fondo_azul">
						            		<h4 class="raleway_regular blanco mb-0 py-2 h5">CARACTERÍSTICAS</h4>
						            	</div>
						            </div>
						            <div class="row">
						            	<div class="col-12 fondo_blanco bordes-inferiores py-2">
						            		<p class="text-left raleway_regular"><small><?php echo e($colchon[0] -> caracteristicas); ?></small></p>
						            	</div>
						            </div>
						        </div>

						        <!-- LAYER NR. 8 original -->
						        <div class="tp-caption   tp-resizeme rs-parallaxlevel-2" 
						            id="slide-3074-layer-6" 
						            data-x="['right','right','center','center']" data-hoffset="['70','50','200','150']" 
						            data-y="['bottom','bottom','center','center']" data-voffset="['180','170','-300','-350']" 
						            data-width="none"
						            data-height="none"
						            data-whitespace="nowrap"
						 
						            data-type="image" 
						            data-responsive_offset="on" 

						            data-frames='[{"delay":3750,"speed":1500,"frame":"0","from":"z:0;rX:0;rY:0;rZ:0;sX:0.8;sY:0.8;skX:0;skY:0;opacity:0;","to":"o:1;","ease":"Power4.easeOut"},{"delay":"wait","speed":300,"frame":"999","to":"auto:auto;","ease":"Power3.easeInOut"}]'
						            data-textAlign="['left','left','left','left']"
						            data-paddingtop="[0,0,0,0]"
						            data-paddingright="[0,0,0,0]"
						            data-paddingbottom="[0,0,0,0]"
						            data-paddingleft="[0,0,0,0]"

						            data-actions='[{
						            	"event": "click", 
						            	"action": "simplelink", 
						            	"target": "_self", 
						            	"url": "<?php echo e(url('/tiendas')); ?>"
						            }]'

						            style="z-index: 20;text-transform:left;border-width:0px;cursor: pointer;"><img src="<?php echo e(asset('img/iconos/donde-compro-mi-colchon.svg')); ?>" alt="Donde Compro mi colchon" data-ww="['150x','150px','120px','120px']" data-hh="['auto']" data-no-retina> </div>
						    </li>
						</ul>
						<div style="display: none !important;" class="tp-static-layers">

					        <!-- LAYER NR. 13 -->
					        <div class="tp-caption tp-static-layer" 
					            id="slider-1084-layer-1" 
					            data-x="['right','right','right','right']" data-hoffset="['30','30','30','30']" 
					            data-y="['top','top','top','top']" data-voffset="['30','30','30','30']" 
					            data-width="none"
					            data-height="none"
					            data-whitespace="nowrap"
					 
					            data-type="text"
					            data-actions='[{"event":"click","action":"toggleclass","layer":"slider-1084-layer-1","delay":"0","classname":"open"},{"event":"click","action":"togglelayer","layerstatus":"hidden","layer":"slider-1084-layer-3","delay":"0"},{"event":"click","action":"togglelayer","layerstatus":"hidden","layer":"slider-1084-layer-4","delay":"0"},{"event":"click","action":"togglelayer","layerstatus":"hidden","layer":"slider-1084-layer-5","delay":"0"},{"event":"click","action":"togglelayer","layerstatus":"hidden","layer":"slider-1084-layer-6","delay":"0"}]'
					            data-basealign="slide" 
					            data-responsive_offset="off" 
					            data-responsive="off"
					            data-startslide="-1" 
					            data-endslide="-1" 
					            data-frames='[{"from":"opacity:0;","speed":1000,"to":"o:1;","delay":500,"ease":"Power3.easeInOut"},{"delay":"wait","speed":1000,"to":"auto:auto;","ease":"nothing"}]'
					            data-textAlign="['left','left','left','left']"
					            data-paddingtop="[0,0,0,0]"
					            data-paddingright="[0,0,0,0]"
					            data-paddingbottom="[0,0,0,0]"
					            data-paddingleft="[0,0,0,0]"

					            style="z-index: 17; white-space: nowrap; font-size: 20px; line-height: 22px; font-weight: 400; color: rgba(255, 255, 255, 1.00);text-transform:left;border-width:0px;">XDDDDD
					            <div id="rev-burger">
					  				<span></span>
					  				<span></span>
					  				<span></span></div></div>
						</div>
						<div class="tp-bannertimer tp-bottom" style="visibility: hidden !important;"></div>
					</div>
				</div><!-- END REVOLUTION SLIDER -->
		
			</article>
		</section>
	<?php endif; ?>
	<!-- Modal -->
	<div class="modal fade" id="modal-imagen-alta" tabindex="-1" role="dialog" aria-labelledby="modal-imagen-altaLabel" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
			<div class="modal-content">
				<div class="modal-header d-none">
					<h5 class="modal-title" id="modal-imagen-altaLabel">Modal title</h5>
				</div>
				<div class="modal-body">
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
					<img src="" alt="<?php echo e($colchon[0] -> nombre); ?>" class="img-fluid mx-auto d-block lazy-load zoom-img" data-src-lazy="<?php echo e(asset('img/colchones/alta/'.$colchon[0] -> imagen.'')); ?>">
				</div>
				<div class="modal-footer d-none">
					<button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
					<button type="button" class="btn btn-primary">Save changes</button>
				</div>
			</div>
		</div>
	</div>
	<?php
		$aux = $colchon[0] -> id;
	?>
	<section class="py-3" id="colchones_mini" <?php if(!$agent->isMobile() || !$agent->isTablet()): ?> style="margin-top: -150px;" <?php else: ?> style="background-image: url(<?php echo e(asset('img/fondos/linea-hogar-colchones-carreiro.jpg')); ?>);background-size: cover;background-repeat: no-repeat;background-position: center;background-attachment: fixed;" <?php endif; ?>>
		<div class="container">
			<div class="row">
				<div class="col-sm-10 col-md-9 col-lg-8 col-xl-7 mx-auto">
					<div id="carousel_miniaturas" class="mt-4">
						<?php $__currentLoopData = $colchones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $colchon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<div <?php if($slug == $colchon -> slug): ?> class="slick-active" <?php endif; ?>>
								<h6 class="raleway_bold text-center azul"><small><?php echo e($colchon -> nombre); ?></small></h6>
								<a href="<?php echo e(url('/linea/hogar/'.$colchon -> slug.'')); ?>">
									<img src="<?php echo e(asset('img/colchones/miniaturas/'.$colchon -> imagen.'')); ?>" alt="<?php echo e($colchon -> nombre); ?> Colchones Carreiro" class="mx-auto img-fluid d-block">
								</a>
							</div>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</div>
				</div>
			</div>
		</div>
	</section>
	<?php echo $__env->make('includes.footer', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
	<!-- jQuery first, then Popper.js, then Bootstrap JS -->
    <script src="<?php echo e(asset('jquery/jquery-3.3.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset('popper/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bootstrap-4/js/bootstrap.min.js')); ?>"></script>
    
    <script src="<?php echo e(asset('font-awesome-5.0.8/all.js')); ?>"></script>
    
    <script src="<?php echo e(asset('elevatezoom-master/jquery.elevateZoom-3.0.8.min.js')); ?>"></script>
    

    <?php if(!$agent->isMobile() || !$agent->isTablet()): ?>
	    <!-- REVOLUTION JS FILES -->
	    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/jquery.themepunch.tools.min.js')); ?>"></script>
	    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/jquery.themepunch.revolution.min.js')); ?>"></script>

	    <!-- SLIDER REVOLUTION 5.0 EXTENSIONS  (Load Extensions only on Local File Systems !  The following part can be removed on Server for On Demand Loading) -->    
	    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/extensions/revolution.extension.actions.min.js')); ?>"></script>
	    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/extensions/revolution.extension.carousel.min.js')); ?>"></script>
	    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/extensions/revolution.extension.kenburn.min.js')); ?>"></script>
	    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/extensions/revolution.extension.layeranimation.min.js')); ?>"></script>
	    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/extensions/revolution.extension.migration.min.js')); ?>"></script>
	    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/extensions/revolution.extension.navigation.min.js')); ?>"></script>
	    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/extensions/revolution.extension.parallax.min.js')); ?>"></script>
	    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/extensions/revolution.extension.slideanims.min.js')); ?>"></script>
	    <script type="text/javascript" src="<?php echo e(asset('slider-revolution/revolution/js/extensions/revolution.extension.video.min.js')); ?>"></script>
    <?php endif; ?>



	
	<script src="<?php echo e(asset('slick-1.8.0/slick.min.js')); ?>"></script>
    
    <script src="<?php echo e(asset('js/globales.js')); ?>"></script>
    <script src="<?php echo e(asset('js/hogar.js')); ?>"></script>
    
    <script>
    	var id = <?php echo e($aux); ?>;
    	var path = '<?php echo e(Request::root()); ?>';
    </script>

</body>
</html>