<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>">
<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('bootstrap-4/css/bootstrap.min.css')); ?>" >
    
    <link rel="stylesheet" href="<?php echo e(asset('animate-css/animate.css')); ?>">
	<!-- Coloca este código dentro de la etiqueta <head> de tu web -->
	<title><?php echo $__env->yieldContent('titulo'); ?> | Colchones Carreiro</title>
	<meta name="description" content="<?php echo $__env->yieldContent('descripcion'); ?>" />

	<!-- Twitter Card data -->
	<meta name="twitter:card" value="summary_large">

	<!-- Open Graph data -->
	<meta property="og:title" content="<?php echo $__env->yieldContent('titulo'); ?> | Colchones Carreiro" />
	<meta property="og:type" content="website" />
	<meta property="og:url" content="<?php echo e(Request::fullUrl()); ?>" />
	<meta property="og:image" content="<?php echo $__env->yieldContent('imagen'); ?>" />
	<meta property="og:description" content="<?php echo $__env->yieldContent('descripcion'); ?>" />
	
	<link rel="stylesheet" href="<?php echo e(asset('css/fuentes.css?v=2')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('css/globales.css?v=1')); ?>">
	<?php echo $__env->yieldContent('css'); ?>
</head>
<body>
	<div id="loader"></div>
	<?php echo $__env->make('includes.header', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
	<?php echo $__env->yieldContent('contenido'); ?>
	<?php echo $__env->make('includes.footer', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
	<!-- jQuery first, then Popper.js, then Bootstrap JS -->
    <script src="<?php echo e(asset('jquery/jquery-3.3.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset('popper/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bootstrap-4/js/bootstrap.min.js')); ?>"></script>
    
    <script src="<?php echo e(asset('font-awesome-5.0.8/all.js')); ?>"></script>
    <?php echo $__env->yieldContent('js'); ?>
    
    <script src="<?php echo e(asset('js/globales.js')); ?>"></script>
    <script>var path = '<?php echo e(Request::root()); ?>';</script>
    <script>
    	$('.scroll').click(function(event) {
    		event.preventDefault();
    		console.log('scroll')
    		var target = $(this).attr('href');
    		$('html, body').animate({
    			scrollTop: $(target).offset().top -66
    		}, 800);
    	});
    </script>
</body>
</html>